/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.ImageScreen;
import java.util.HashMap;
import java.util.UUID;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.world.inventory.CrazyPhoneMayorCandidateScreenMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Matrix4f;

public class CrazyPhoneMayorCandidateScreenScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhoneMayorCandidateScreenMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhoneMayorCandidateScreenMenu.guistate;
    private static final ResourceLocation BANNER_IMAGE = ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-header-background.png");
    private Contact mayorCandidate;
    private ImageData candidatePosterData = null;
    private ItemStack candidateHead = ItemStack.EMPTY;
    private int scrollOffsetY = 0;
    private int maxScroll = 0;
    private Button voteButton;

    public CrazyPhoneMayorCandidateScreenScreen(CrazyPhoneMayorCandidateScreenMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
    }

    public static HashMap<String, String> getEditBoxAndCheckBoxValues() {
        return new HashMap<String, String>();
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    @Override
    public void init() {
        CompoundTag mayorPhone;
        super.init();
        String mayorNumber = ((CrazyPhoneMayorCandidateScreenMenu)this.menu).mayorNumber;
        Tag tag = CrazythingsModVariables.MapVariables.get((LevelAccessor)this.world).phones.get(mayorNumber);
        if (tag instanceof CompoundTag) {
            CompoundTag _compoundTag = (CompoundTag)tag;
            v0 = _compoundTag.copy();
        } else {
            v0 = mayorPhone = new CompoundTag();
        }
        if (mayorPhone == null) {
            return;
        }
        this.mayorCandidate = CrazyPhoneHelper.getContact(((CrazyPhoneMayorCandidateScreenMenu)this.menu).world, mayorNumber);
        Tag potentialImage = CrazythingsModVariables.MapVariables.get((LevelAccessor)this.world).mayorsCandidates.get(mayorNumber);
        if (potentialImage instanceof CompoundTag) {
            this.candidatePosterData = ImageData.fromImageTag((CompoundTag)((CompoundTag)potentialImage));
        }
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.candidateHead = CrazyPhoneHelper.createContactHead(this.mayorCandidate);
        boolean votingOpen = CrazythingsModVariables.MapVariables.get((LevelAccessor)this.world).isMayorVotingOn;
        this.voteButton = Button.builder((Component)Component.literal((String)"Voter"), b -> Minecraft.getInstance().player.connection.sendCommand("phoneVoteForMayor " + mayorNumber)).bounds(this.leftPos + 6, this.topPos + 160, 110, 14).build();
        this.voteButton.active = votingOpen;
        this.addRenderableWidget((GuiEventListener)this.voteButton);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        super.renderBg(guiGraphics, partialTicks, gx, gy);
        this.renderCandidateHeader(guiGraphics);
        this.renderScissoredPanel(guiGraphics);
    }

    private void renderCandidateHeader(GuiGraphics guiGraphics) {
        guiGraphics.blit(BANNER_IMAGE, this.leftPos + 4, this.topPos + 9, 0, 0.0f, 0.0f, 114, 18, 114, 18);
        if (!this.candidateHead.isEmpty()) {
            guiGraphics.renderItem(this.candidateHead, this.leftPos + 7, this.topPos + 9);
        }
        guiGraphics.drawString(this.font, this.mayorCandidate.getName(), this.leftPos + 26, this.topPos + 14, 0x404040, false);
    }

    private void renderScissoredPanel(GuiGraphics guiGraphics) {
        guiGraphics.enableScissor(this.leftPos, this.topPos + 27, this.leftPos + 200, this.topPos + 158);
        this.renderImage(guiGraphics);
        guiGraphics.disableScissor();
    }

    private void renderImage(GuiGraphics guiGraphics) {
        UUID imageID;
        if (this.candidatePosterData == null) {
            return;
        }
        if (this.imageWidth <= 0 || this.imageHeight <= 0) {
            this.initImageScaling();
        }
        if ((imageID = this.candidatePosterData.getId()) == null) {
            return;
        }
        int x = this.leftPos + 6;
        int y = this.topPos + 26 - this.scrollOffsetY;
        CrazyPhoneMayorCandidateScreenScreen.drawImage(guiGraphics, Minecraft.getInstance(), x, y + 1, this.imageWidth, this.imageHeight, 0.0f, imageID);
    }

    public void initImageScaling() {
        ImageData imageData = this.candidatePosterData;
        if (imageData != null) {
            UUID imageID = imageData.getId();
            NativeImage nativeImage = TextureCache.instance().getNativeImage(imageID);
            if (nativeImage != null) {
                float imgWidth = nativeImage.getWidth();
                float imgHeight = nativeImage.getHeight();
                int maxWidth = 110;
                int maxHeight = 132;
                this.imageWidth = maxWidth;
                this.imageHeight = (int)((float)maxWidth * imgHeight / imgWidth);
                this.maxScroll = Math.max(0, this.imageHeight - maxHeight);
            }
        }
    }

    public boolean mouseScrolled(double x, double y, double dx, double dy) {
        if (this.imageHeight > 0) {
            this.scrollOffsetY -= (int)(dy * 10.0);
            this.scrollOffsetY = Math.max(0, Math.min(this.scrollOffsetY, this.maxScroll));
            return true;
        }
        return true;
    }

    public static void drawImage(GuiGraphics guiGraphics, Minecraft minecraft, int x, int y, int width, int height, float zLevel, UUID uuid) {
        float hnew;
        float wnew;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        float imageWidth = 12.0f;
        float imageHeight = 8.0f;
        if (location == null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ImageScreen.DEFAULT_IMAGE);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            if (image != null) {
                imageWidth = image.getWidth();
                imageHeight = image.getHeight();
            }
        }
        float ws = width;
        float hs = height;
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float left = (ws - wnew) / 2.0f;
        float top = (hs - hnew) / 2.0f;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, left, top, zLevel).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, left, top + hnew, zLevel).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, left + wnew, top + hnew, zLevel).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, left + wnew, top, zLevel).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        guiGraphics.pose().popPose();
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

