/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import de.maxhenkel.camera.gui.ImageScreen;
import net.mcreator.crazythings.network.CrazyPhoneAlbumClosedMessage;
import net.mcreator.crazythings.network.CrazyPhoneImageActionMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhoneImageScreen
extends ImageScreen {
    private final ItemStack image;
    private Button button_take;

    public CrazyPhoneImageScreen(ItemStack image) {
        super(image);
        this.image = image;
    }

    protected void init() {
        super.init();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 5;
        int totalWidth = buttonWidth * 2 + spacing;
        int startX = (this.width - totalWidth) / 2;
        int y = this.height - 30;
        this.button_take = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_pictures_screen.button_take"), e -> {
            if (!this.image.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneImageActionMessage(this.image.copy(), CrazyPhoneImageActionMessage.ImageActionType.GIVE_PLAYER), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Minecraft.getInstance().player.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
            }
        }).bounds(startX, y, buttonWidth, buttonHeight).build();
        Button button_addToAlbum = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_pictures_screen.button_add_album"), e -> {
            if (!this.image.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneImageActionMessage(this.image.copy(), CrazyPhoneImageActionMessage.ImageActionType.GIVE_ALBUM), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Minecraft.getInstance().player.playSound(SoundEvents.BOOK_PUT, 1.0f, 1.0f);
            }
        }).bounds(startX + buttonWidth + spacing, y, buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.button_take);
        this.addRenderableWidget((GuiEventListener)button_addToAlbum);
    }

    public void onClose() {
        super.onClose();
        PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneAlbumClosedMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

