/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import java.util.HashMap;
import java.util.List;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.client.gui.components.MessageData;
import net.mcreator.crazythings.client.gui.components.MessageDisplayManager;
import net.mcreator.crazythings.client.gui.components.SmallTextEditBox;
import net.mcreator.crazythings.network.CrazyPhoneConversationButtonMessage;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.world.inventory.CrazyPhoneConversationMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhoneConversationScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhoneConversationMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhoneConversationMenu.guistate;
    private EditBox message;
    private Button button_envoyer;
    private ImageButton imagebutton_crazyphoneaddimage;
    private int scrollPosition = 0;
    private static final int SCROLL_STEP = 10;
    private MessageDisplayManager messageManager;
    private static final ResourceLocation BANNER_IMAGE = ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-header-background.png");

    public CrazyPhoneConversationScreen(CrazyPhoneConversationMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
    }

    public static HashMap<String, String> getEditBoxAndCheckBoxValues() {
        HashMap<String, String> textstate = new HashMap<String, String>();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CrazyPhoneConversationScreen) {
            CrazyPhoneConversationScreen sc = (CrazyPhoneConversationScreen)screen;
            textstate.put("textin:message", sc.message.getValue());
            textstate.put("conversationId", ((CrazyPhoneConversationMenu)sc.menu).getConversationId());
        }
        return textstate;
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.updateButtonVisibility(mouseX, mouseY);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBanner(guiGraphics);
        this.renderMessageWidget(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderBanner(GuiGraphics guiGraphics) {
        guiGraphics.blit(BANNER_IMAGE, this.leftPos + 4, this.topPos + 9, 0, 0.0f, 0.0f, 114, 18, 114, 18);
        String ownerNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)((CrazyPhoneConversationMenu)this.menu).entity, null);
        List<Contact> otherContacts = ((CrazyPhoneConversationMenu)this.menu).getContacts().stream().filter(contact -> !contact.getNumber().equals(ownerNumber)).toList();
        if (otherContacts.isEmpty()) {
            return;
        }
        ItemStack contactHead = CrazyPhoneHelper.createContactHead(otherContacts.get(0));
        guiGraphics.renderItem(contactHead, this.leftPos + 7, this.topPos + 9);
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < otherContacts.size(); ++i) {
            names.append(otherContacts.get(i).getName());
            if (i >= otherContacts.size() - 1) continue;
            names.append(", ");
        }
        guiGraphics.drawString(this.font, names.toString(), this.leftPos + 26, this.topPos + 14, 0x404040, false);
    }

    private void updateButtonVisibility(int mouseX, int mouseY) {
        boolean isButtonEnvoyerHovered = this.button_envoyer.isMouseOver((double)mouseX, (double)mouseY);
        boolean isImageButtonHovered = this.imagebutton_crazyphoneaddimage.isMouseOver((double)mouseX, (double)mouseY);
        boolean bl = this.imagebutton_crazyphoneaddimage.visible = isButtonEnvoyerHovered || isImageButtonHovered;
        if (this.imagebutton_crazyphoneaddimage.visible && !isButtonEnvoyerHovered && !isImageButtonHovered) {
            this.imagebutton_crazyphoneaddimage.visible = false;
        } else if (!this.imagebutton_crazyphoneaddimage.visible && isButtonEnvoyerHovered) {
            this.imagebutton_crazyphoneaddimage.visible = true;
        }
    }

    private void renderMessageWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.enableScissor(this.leftPos, this.topPos + 25, this.leftPos + 200, this.topPos + 158);
        this.messageManager.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.disableScissor();
    }

    public boolean mouseScrolled(double x, double y, double dx, double dy) {
        this.scrollPosition = (int)((double)this.scrollPosition + dy * 10.0);
        if (this.scrollPosition < 0 || this.messageManager.getTotalHeight() <= 132) {
            this.scrollPosition = 0;
        } else if (this.scrollPosition > this.messageManager.getTotalHeight() - 132) {
            this.scrollPosition = this.messageManager.getTotalHeight() - 132;
        }
        this.messageManager.setScrollOffset(this.scrollPosition);
        return true;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
    }

    @Override
    public void init() {
        super.init();
        this.initializeButtons();
        this.initializeTextAndMessageWidget();
        this.initializeEditBox();
        this.addRenderableWidgets();
    }

    private void initializeTextAndMessageWidget() {
        String ownerNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)((CrazyPhoneConversationMenu)this.menu).entity, null);
        this.messageManager = new MessageDisplayManager(this.leftPos + 7, this.topPos + 158, 93, 0.75f, ((CrazyPhoneConversationMenu)this.menu).getContacts(), ownerNumber);
        for (MessageData message : ((CrazyPhoneConversationMenu)this.menu).getMessages()) {
            this.messageManager.addMessage(message);
        }
    }

    private void initializeEditBox() {
        this.message = new SmallTextEditBox(this, this.font, this.leftPos + 7, this.topPos + 159, 93, 14, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_conversation.message")){

            public void insertText(String text) {
                super.insertText(text);
                this.updateSuggestion();
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                this.updateSuggestion();
            }

            private void updateSuggestion() {
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.crazythings.crazy_phone_conversation.message").getString());
                } else {
                    this.setSuggestion(null);
                }
            }
        };
        this.message.setMaxLength(Short.MAX_VALUE);
        this.message.setSuggestion(Component.translatable((String)"gui.crazythings.crazy_phone_conversation.message").getString());
        guistate.put("text:message", this.message);
        this.addWidget((GuiEventListener)this.message);
    }

    private void initializeButtons() {
        this.button_envoyer = this.createSendMessageButton();
        this.imagebutton_crazyphoneaddimage = this.createImageButton();
    }

    private ImageButton createSendMessageButton() {
        ResourceLocation sendButtonImage = ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-send-message.png");
        ResourceLocation sendButtonHoverImage = ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-send-message-hover.png");
        return new ImageButton(this, this.leftPos + 101, this.topPos + 159, 14, 14, new WidgetSprites(sendButtonImage, sendButtonHoverImage), e -> {
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (patt0$temp instanceof CrazyPhoneConversationScreen) {
                CrazyPhoneConversationScreen sc = (CrazyPhoneConversationScreen)patt0$temp;
                if (!sc.message.getValue().isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneConversationButtonMessage(0, this.x, this.y, this.z, CrazyPhoneConversationScreen.getEditBoxAndCheckBoxValues()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    CrazyPhoneConversationButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z, CrazyPhoneConversationScreen.getEditBoxAndCheckBoxValues());
                }
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 500, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
    }

    private ImageButton createImageButton() {
        ImageButton button = new ImageButton(this, this.leftPos + 101, this.topPos + 144, 14, 15, new WidgetSprites(ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-add-image.png"), ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-add-hover.png")), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneConversationButtonMessage(1, this.x, this.y, this.z, CrazyPhoneConversationScreen.getEditBoxAndCheckBoxValues()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CrazyPhoneConversationButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z, CrazyPhoneConversationScreen.getEditBoxAndCheckBoxValues());
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 500, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        button.visible = false;
        return button;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.button_envoyer.isMouseOver(mouseX, mouseY)) {
            this.button_envoyer.onPress();
            return true;
        }
        if (!this.imagebutton_crazyphoneaddimage.visible) {
            for (MessageDisplayManager.MessageEntry entry : this.messageManager.getMessages()) {
                if (!entry.widget().mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void addRenderableWidgets() {
        this.addRenderableWidget((GuiEventListener)this.message);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_crazyphoneaddimage);
        this.addRenderableWidget((GuiEventListener)this.button_envoyer);
    }

    public void addMessage(String senderName, MessageData newMessageData) {
        String ownerNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)((CrazyPhoneConversationMenu)this.menu).entity, null);
        if (newMessageData.getSender().equals(ownerNumber)) {
            return;
        }
        boolean isKnownContact = ((CrazyPhoneConversationMenu)this.menu).getContacts().stream().anyMatch(contact -> contact.getNumber().equals(newMessageData.getSender()));
        if (!isKnownContact) {
            return;
        }
        MessageDisplayManager.MessageEntry entry = this.messageManager.addMessage(newMessageData);
        this.addRenderableWidget((GuiEventListener)entry.widget());
    }
}

