/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.network.CrazyPhoneContactsScreenButtonMessage;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.world.inventory.CrazyPhoneContactsScreenMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhoneContactsScreenScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhoneContactsScreenMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhoneContactsScreenMenu.guistate;
    private static final ResourceLocation NOTIFICATION_IMAGE = ResourceLocation.parse((String)"crazythings:textures/screens/crazyphone-notification.png");
    private List<String> pendingNotifications;
    public static ShaderInstance WHITE_SHADER;
    public static final ResourceLocation WHITE_TEXTURE;
    public static final RenderType FULL_WHITE;

    public CrazyPhoneContactsScreenScreen(CrazyPhoneContactsScreenMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
        String playerNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)this.entity, null);
        Tag tag = CrazythingsModVariables.MapVariables.get((LevelAccessor)this.entity.level()).phones.get(playerNumber);
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            ListTag notifList = compound.getList("notifications", 8);
            this.pendingNotifications = notifList.stream().filter(t -> t instanceof StringTag).map(t -> ((StringTag)t).getAsString()).toList();
        }
        CrazyPhoneContactsScreenScreen.loadShaders();
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    public static void loadShaders() {
        try {
            WHITE_SHADER = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"white"), DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < ((CrazyPhoneContactsScreenMenu)this.menu).slots.size(); ++i) {
            Slot slot = ((CrazyPhoneContactsScreenMenu)this.menu).getSlot(i);
            ItemStack stack = slot.getItem();
            if (stack.isEmpty()) continue;
            int slotX = this.leftPos + slot.x;
            int slotY = this.topPos + slot.y;
            boolean hovering = this.isHovering(slot, mouseX, mouseY);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(slotX + 8), (float)(slotY + 8), 100.0f);
            if (hovering) {
                guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
                guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-15.0f));
            }
            guiGraphics.pose().translate(-8.0f, -8.0f, 0.0f);
            guiGraphics.renderItem(stack, 0, 0);
            guiGraphics.pose().popPose();
            String number = CrazyPhoneContactsScreenScreen.getContactNumber(stack);
            if (number == null || number.isEmpty() || !this.pendingNotifications.stream().anyMatch(id -> id.contains(number))) continue;
            guiGraphics.blit(NOTIFICATION_IMAGE, slotX, slotY, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    private void renderItemContour(GuiGraphics guiGraphics, ItemStack stack, int slotX, int slotY, ItemRenderer itemRenderer, int dx, int dy) {
        int px = dx;
        int py = dy;
        int light = 0xFFFFFF;
        int overlay = OverlayTexture.NO_OVERLAY;
        if (!stack.isEmpty()) {
            Block block;
            PoseStack poseStack = guiGraphics.pose();
            MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
            poseStack.pushPose();
            poseStack.translate((float)(slotX + px + 8), (float)(slotY + py + 8), 50.0f);
            poseStack.scale(16.0f, -16.0f, 16.0f);
            poseStack.scale(1.5f, 1.5f, 1.5f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(15.0f));
            ItemStack glintStack = stack.copy();
            glintStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            BakedModel model = itemRenderer.getModel(glintStack, null, null, 0);
            ItemDisplayContext context = ItemDisplayContext.GUI;
            boolean flag = context == ItemDisplayContext.GUI || context == ItemDisplayContext.GROUND || context == ItemDisplayContext.FIXED;
            model = ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)context, (boolean)true);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            Item item = glintStack.getItem();
            if (item instanceof BlockItem && (block = ((BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
                AbstractSkullBlock abstractskullblock = (AbstractSkullBlock)block;
                ResolvableProfile resolvableprofile = (ResolvableProfile)glintStack.get(DataComponents.PROFILE);
                if (resolvableprofile != null && !resolvableprofile.isResolved()) {
                    glintStack.remove(DataComponents.PROFILE);
                    resolvableprofile.resolve().thenAcceptAsync(p_329787_ -> glintStack.set(DataComponents.PROFILE, p_329787_), (Executor)Minecraft.getInstance());
                    resolvableprofile = null;
                }
                EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
                SkullModel modelHead = new SkullModel(modelSet.bakeLayer(ModelLayers.PLAYER_HEAD));
                ResourceLocation resourcelocation = DefaultPlayerSkin.getDefaultTexture();
                if (resolvableprofile != null) {
                    SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
                    RenderType rendertype = RenderType.entityTranslucent((ResourceLocation)skinmanager.getInsecureSkin(resolvableprofile.gameProfile()).texture());
                } else {
                    RenderType rendertype = RenderType.entityCutoutNoCullZOffset((ResourceLocation)resourcelocation);
                }
                RenderType fullbrightWhite = RenderType.entityTranslucentEmissive((ResourceLocation)WHITE_TEXTURE, (boolean)true);
                float whiteLight = 1.572888E7f;
                SkullBlockRenderer.renderSkull(null, (float)180.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)((int)whiteLight), (SkullModelBase)modelHead, (RenderType)fullbrightWhite);
            }
            poseStack.popPose();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        HashMap<String, String> textstate = CrazyPhoneContactsScreenScreen.getEditBoxAndCheckBoxValues();
        for (int i = 0; i < ((CrazyPhoneContactsScreenMenu)this.menu).slots.size(); ++i) {
            Slot slot = ((CrazyPhoneContactsScreenMenu)this.menu).getSlot(i);
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            ItemStack clickedStack = slot.getItem();
            if (CrazyPhoneContactsScreenMenu.isAddContactHead(clickedStack)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneContactsScreenButtonMessage(0, this.x, this.y, this.z, textstate), (CustomPacketPayload[])new CustomPacketPayload[0]);
                CrazyPhoneContactsScreenButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z, textstate);
                return true;
            }
            textstate.put("contactNumber", CrazyPhoneContactsScreenScreen.getContactNumber(clickedStack));
            PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneContactsScreenButtonMessage(1, this.x, this.y, this.z, textstate), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CrazyPhoneContactsScreenButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z, textstate);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static String getContactNumber(ItemStack head) {
        return ((CustomData)head.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("number");
    }

    private boolean isHovering(Slot slot, double mouseX, double mouseY) {
        int slotX = slot.x + this.leftPos;
        int slotY = slot.y + this.topPos;
        return mouseX >= (double)slotX && mouseX < (double)(slotX + 16) && mouseY >= (double)slotY && mouseY < (double)(slotY + 16);
    }

    @Override
    public void init() {
        super.init();
    }

    static {
        WHITE_TEXTURE = ResourceLocation.parse((String)"minecraft:textures/block/snow.png");
        FULL_WHITE = RenderType.create((String)"entity_white", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WHITE_TEXTURE, false, false)).setWriteMaskState(RenderType.COLOR_DEPTH_WRITE).setCullState(RenderType.NO_CULL).setLightmapState(RenderType.NO_LIGHTMAP).setDepthTestState(RenderType.LEQUAL_DEPTH_TEST).setTransparencyState(RenderType.NO_TRANSPARENCY).createCompositeState(true));
    }
}

