/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.network.CrazyPhoneContactInfoScreenButtonMessage;
import net.mcreator.crazythings.world.inventory.CrazyPhoneContactInfoScreenMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CrazyPhoneContactInfoScreenScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhoneContactInfoScreenMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhoneContactInfoScreenMenu.guistate;
    EditBox number;
    Button button_ajouter;
    private static final String[] defaultNames = new String[]{"Steve", "Asksan"};
    private static final UUID[] defaultUUIDs = new UUID[]{UUID.fromString("792d387e-73d9-4906-9e6f-b8a84c887043"), UUID.fromString("2d5111f6-77fb-4a25-ba72-b6c6648ec801")};
    private Player fakePlayer;
    private String currentName;
    private UUID currentUUID;
    private GameProfile profile;

    public CrazyPhoneContactInfoScreenScreen(CrazyPhoneContactInfoScreenMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
        this.createGuiDefaultFakePlayer();
    }

    public static HashMap<String, String> getEditBoxAndCheckBoxValues() {
        HashMap<String, String> textstate = new HashMap<String, String>();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CrazyPhoneContactInfoScreenScreen) {
            CrazyPhoneContactInfoScreenScreen sc = (CrazyPhoneContactInfoScreenScreen)screen;
            textstate.put("textin:number", sc.number.getValue());
        }
        return textstate;
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.number.render(guiGraphics, mouseX, mouseY, partialTicks);
        Player player = this.fakePlayer;
        if (player instanceof LivingEntity) {
            Player livingEntity = player;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 61, this.topPos + 137, 50, (float)Math.atan((double)(this.leftPos + 85 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 29 - mouseY) / 40.0), (LivingEntity)livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void createGuiDefaultFakePlayer() {
        int randomIndex = new Random().nextInt(defaultNames.length);
        this.currentName = defaultNames[randomIndex];
        this.currentUUID = defaultUUIDs[randomIndex];
        this.createGuiFakePlayer(this.currentName, this.currentUUID, false);
    }

    public void createGuiFakePlayer(String name, UUID uuid, boolean isConnected) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            this.createGuiDefaultFakePlayer();
            return;
        }
        try {
            this.profile = new GameProfile(uuid, name);
            SkinManager skinManager = Minecraft.getInstance().getSkinManager();
            CompletableFuture skinFuture = skinManager.getOrLoad(this.profile);
            skinFuture.thenAccept(playerSkin -> {
                PlayerInfo playerInfo = new PlayerInfo(this.profile, false);
                playerInfo.getSkin();
                this.fakePlayer = new RemotePlayer(level, this.profile);
                this.fakePlayer.refreshDisplayName();
                level.addFreshEntity((Entity)this.fakePlayer);
            });
        }
        catch (Exception e) {
            this.createGuiDefaultFakePlayer();
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String numberValue = this.number.getValue();
        super.resize(minecraft, width, height);
        this.number.setValue(numberValue);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_contact_info_screen.label_numero"), 10, 144, -12829636, false);
    }

    @Override
    public void init() {
        super.init();
        this.number = new EditBox(this, this.font, this.leftPos + 10, this.topPos + 157, 53, 18, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_contact_info_screen.number")){

            public void insertText(String text) {
                super.insertText(text);
                this.setSuggestion(this.getValue().isEmpty() ? Component.translatable((String)"gui.crazythings.crazy_phone_contact_info_screen.number").getString() : null);
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                this.setSuggestion(this.getValue().isEmpty() ? Component.translatable((String)"gui.crazythings.crazy_phone_contact_info_screen.number").getString() : null);
            }
        };
        this.number.setMaxLength(Short.MAX_VALUE);
        this.number.setSuggestion(Component.translatable((String)"gui.crazythings.crazy_phone_contact_info_screen.number").getString());
        this.number.setResponder(text -> {
            if (this.entity != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneContactInfoScreenButtonMessage(1, this.x, this.y, this.z, CrazyPhoneContactInfoScreenScreen.getEditBoxAndCheckBoxValues()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                CrazyPhoneContactInfoScreenButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z, CrazyPhoneContactInfoScreenScreen.getEditBoxAndCheckBoxValues());
            }
        });
        guistate.put("text:number", this.number);
        this.addWidget((GuiEventListener)this.number);
        this.button_ajouter = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_contact_info_screen.button_ajouter"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneContactInfoScreenButtonMessage(0, this.x, this.y, this.z, CrazyPhoneContactInfoScreenScreen.getEditBoxAndCheckBoxValues()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CrazyPhoneContactInfoScreenButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z, CrazyPhoneContactInfoScreenScreen.getEditBoxAndCheckBoxValues());
        }).bounds(this.leftPos + 67, this.topPos + 156, 46, 20).build();
        guistate.put("button:button_ajouter", this.button_ajouter);
        this.addRenderableWidget((GuiEventListener)this.button_ajouter);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }

    public void updateContactInfo(String name, String uuidStr, String number2) {
        try {
            this.currentName = name;
            this.currentUUID = UUID.fromString(uuidStr);
            this.createGuiFakePlayer(this.currentName, this.currentUUID, true);
        }
        catch (IllegalArgumentException e) {
            CrazythingsMod.LOGGER.error("Invalid UUID string: " + uuidStr);
            this.createGuiDefaultFakePlayer();
        }
    }
}

