/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.block.entity;

import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.crazythings.init.CrazythingsModBlockEntities;
import net.mcreator.crazythings.world.inventory.OuijaProgramingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OuijaTileEntity
extends RandomizableContainerBlockEntity
implements GeoBlockEntity,
WorldlyContainer {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)0, (Object)ItemStack.EMPTY);
    private final SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, null);
    private String currentAnimation = "idle";
    private String lastAnimation = "";
    private boolean resetAnimation = false;
    private boolean isFloating = false;
    private boolean wasFloating = false;
    private boolean firstOnthefloorSkipped = false;
    private static final char FLOAT_ON_CHAR = '^';
    private static final char FLOAT_OFF_CHAR = '_';
    private final Queue<String> animationQueue = new LinkedList<String>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public OuijaTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CrazythingsModBlockEntities.OUIJA.get(), pos, state);
    }

    public void triggerAnimationSequence(String inputText, long waitTime) {
        String cleanText = OuijaTileEntity.cleanInputText(inputText);
        for (char c : cleanText.toCharArray()) {
            if (c == '^') {
                this.isFloating = true;
                continue;
            }
            if (c == '_') {
                this.isFloating = false;
                continue;
            }
            this.animationQueue.add(String.valueOf(c));
        }
        if (!this.animationQueue.isEmpty()) {
            this.playNextAnimation(waitTime);
        }
    }

    public void triggerAnimation(String letter, long waitTime) {
        this.animationQueue.add(letter);
        if (this.animationQueue.size() == 1) {
            this.playNextAnimation(waitTime);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public static String cleanInputText(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[^a-zA-Z+\\- \\^_]", "").toUpperCase();
    }

    private void playNextAnimation(long waitTime) {
        if (this.animationQueue.isEmpty()) {
            return;
        }
        String currentAnim = this.animationQueue.poll();
        if (currentAnim != null) {
            switch (currentAnim) {
                case "+": {
                    this.currentAnimation = "yes";
                    break;
                }
                case "-": {
                    this.currentAnimation = "no";
                    break;
                }
                case " ": {
                    this.currentAnimation = "idle";
                    break;
                }
                default: {
                    this.currentAnimation = currentAnim;
                }
            }
            this.resetAnimation = true;
            if (!this.currentAnimation.equals("idle") && !this.currentAnimation.equals(this.lastAnimation)) {
                this.playPlanchetteSlidingSound();
            }
            this.scheduler.schedule(() -> {
                if (this.getLevel() == null) {
                    return;
                }
                Minecraft.getInstance().execute(() -> {
                    if (this.animationQueue.isEmpty()) {
                        this.currentAnimation = "idle";
                        this.resetAnimation = true;
                    } else {
                        this.playNextAnimation(waitTime);
                    }
                });
            }, waitTime, TimeUnit.MILLISECONDS);
        }
    }

    private void playPlanchetteSlidingSound() {
        if (this.getLevel() != null) {
            this.getLevel().playLocalSound((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"crazythings:ouija-planchette-slide")), SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
    }

    private void playFloatStartSound() {
        if (this.getLevel() != null) {
            this.getLevel().playLocalSound((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"minecraft:particle.soul_escape")), SoundSource.BLOCKS, 0.8f, 1.1f, false);
        }
    }

    private void playFloatEndSound() {
        if (this.getLevel() != null) {
            this.getLevel().playLocalSound((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"minecraft:block.wood.place")), SoundSource.BLOCKS, 0.8f, 0.95f, false);
        }
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (!this.currentAnimation.equals(this.lastAnimation)) {
            this.lastAnimation = this.currentAnimation;
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.currentAnimation));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState floatPredicate(AnimationState<E> event) {
        if (this.isFloating) {
            if (!this.wasFloating) {
                this.wasFloating = true;
                this.playFloatStartSound();
            }
            if (!this.firstOnthefloorSkipped) {
                this.firstOnthefloorSkipped = true;
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().thenLoop("float"));
        } else if (this.firstOnthefloorSkipped) {
            if (this.wasFloating) {
                this.wasFloating = false;
                this.playFloatEndSound();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlayAndHold("onthefloor"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate));
        data.add(new AnimationController((GeoAnimatable)this, "floatController", 10, this::floatPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"ouija");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new OuijaProgramingMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Ouija");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public SidedInvWrapper getItemHandler() {
        return this.handler;
    }
}

