/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.block.entity;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.crazythings.init.CrazythingsModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class ChichaBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, null);
    private int barrierTicksLeft = -1;
    private BlockPos barrierPos;
    private int color = 16766720;

    public ChichaBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)CrazythingsModBlockEntities.CHICHA.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        if (compound.contains("color", 99)) {
            this.color = compound.getInt("color");
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.putInt("color", this.color);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"chicha");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return ChestMenu.threeRows((int)id, (Inventory)inventory);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Chicha");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public SidedInvWrapper getItemHandler() {
        return this.handler;
    }

    public void setColor(int color) {
        this.color = color;
        this.setChanged();
        this.placeTemporaryBarrier();
    }

    public int getColor() {
        return this.color;
    }

    public void placeTemporaryBarrier() {
        this.barrierPos = this.worldPosition.above();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.setBlock(this.barrierPos, Blocks.BARRIER.defaultBlockState(), 3);
            this.barrierTicksLeft = 2;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChichaBlockEntity blockEntity) {
        blockEntity.tickBarrier();
    }

    public void tickBarrier() {
        if (this.barrierTicksLeft > 0) {
            --this.barrierTicksLeft;
            if (this.barrierTicksLeft == 0 && this.level != null && !this.level.isClientSide()) {
                if (this.level.getBlockState(this.barrierPos).getBlock() == Blocks.BARRIER) {
                    this.level.removeBlock(this.barrierPos, false);
                }
                this.barrierTicksLeft = -1;
            }
        }
    }
}

