/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.mcreator.crazythings.block.entity.renderer.BurnedBlockBlockEntityRenderer;
import net.mcreator.crazythings.init.CrazythingsModBlockEntities;
import net.mcreator.crazythings.init.CrazythingsModBlocks;
import net.mcreator.crazythings.init.CrazythingsModEntities;
import net.mcreator.crazythings.init.CrazythingsModItems;
import net.mcreator.crazythings.init.CrazythingsModMenus;
import net.mcreator.crazythings.init.CrazythingsModParticleTypes;
import net.mcreator.crazythings.init.CrazythingsModSounds;
import net.mcreator.crazythings.init.CrazythingsModTabs;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crazythings")
public class CrazythingsMod {
    public static final Logger LOGGER = LogManager.getLogger(CrazythingsMod.class);
    public static final String MODID = "crazythings";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public CrazythingsMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        CrazythingsModSounds.REGISTRY.register(modEventBus);
        CrazythingsModBlocks.REGISTRY.register(modEventBus);
        CrazythingsModBlockEntities.REGISTRY.register(modEventBus);
        CrazythingsModItems.REGISTRY.register(modEventBus);
        CrazythingsModEntities.REGISTRY.register(modEventBus);
        CrazythingsModTabs.REGISTRY.register(modEventBus);
        CrazythingsModVariables.ATTACHMENT_TYPES.register(modEventBus);
        CrazythingsModMenus.REGISTRY.register(modEventBus);
        CrazythingsModParticleTypes.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::registerEntityRenderers);
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)CrazythingsModBlockEntities.BURNED_BLOCK.get(), BurnedBlockBlockEntityRenderer::new);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

