/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageResizeFrame
implements Message<MessageResizeFrame> {
    public static final CustomPacketPayload.Type<MessageResizeFrame> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"resize_frame"));
    private UUID uuid;
    private Direction direction;
    private boolean larger;

    public MessageResizeFrame() {
    }

    public MessageResizeFrame(UUID uuid, Direction direction, boolean larger) {
        this.uuid = uuid;
        this.direction = direction;
        this.larger = larger;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        Level level = sender.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (sender.getAbilities().mayBuild && (entity = serverLevel.getEntity(this.uuid)) instanceof ImageEntity) {
                ImageEntity image = (ImageEntity)entity;
                image.resize(this.direction, this.larger);
            }
        }
    }

    @Override
    public MessageResizeFrame fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        this.direction = Direction.values()[buf.readInt()];
        this.larger = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
        buf.writeInt(this.direction.ordinal());
        buf.writeBoolean(this.larger);
    }

    @Override
    public CustomPacketPayload.Type<MessageResizeFrame> type() {
        return TYPE;
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

