/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import de.maxhenkel.camera.Main;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AlbumContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData intArray;

    public AlbumContainer(int id) {
        this(id, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(1));
    }

    public AlbumContainer(int id, final Container inventory, ContainerData intArray) {
        super((MenuType)Main.ALBUM_CONTAINER.get(), id);
        AlbumContainer.checkContainerSize((Container)inventory, (int)1);
        AlbumContainer.checkContainerDataCount((ContainerData)intArray, (int)1);
        this.inventory = inventory;
        this.intArray = intArray;
        this.addSlot(new Slot(inventory, 0, Integer.MIN_VALUE, Integer.MIN_VALUE){

            public void setChanged() {
                super.setChanged();
                AlbumContainer.this.slotsChanged(inventory);
            }
        });
        this.addDataSlots(intArray);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    public void setData(int id, int data) {
        super.setData(id, data);
        this.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack getAlbum() {
        return this.inventory.getItem(0);
    }

    public int getPage() {
        return this.intArray.get(0);
    }

    public void setPage(int page) {
        this.setData(0, page);
    }

    public void takeBook(Player player) {
        if (!player.mayBuild()) {
            return;
        }
        ItemStack itemstack = this.inventory.removeItemNoUpdate(0);
        this.inventory.setChanged();
        if (!player.getInventory().add(itemstack)) {
            player.drop(itemstack, false);
        }
    }
}

