/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.direwolf20.buildinggadgets2.util.modes.Copy;
import com.direwolf20.buildinggadgets2.util.modes.Paste;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GadgetCopyPaste
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.COPYPASTEGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.COPYPASTEGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        boolean sneakPressed;
        String templateName;
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        if (GadgetNBT.getPasteReplace(stack)) {
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.voidwarning").withStyle(ChatFormatting.RED));
        }
        if (!(templateName = GadgetNBT.getTemplateName(stack)).isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.templatename", (Object[])new Object[]{templateName}).withStyle(ChatFormatting.AQUA));
        }
        if (sneakPressed = Screen.hasShiftDown()) {
            // empty if block
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (!mode.getId().getPath().equals("copy")) {
            if (mode.getId().getPath().equals("paste")) {
                UUID uuid = GadgetNBT.getUUID(gadget);
                BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().level().getServer()).overworld());
                ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(uuid, false);
                boolean replace = GadgetNBT.getPasteReplace(gadget);
                UUID buildUUID = !replace ? BuildingUtils.build(context.level(), context.player(), buildList, GadgetCopyPaste.getHitPos(context).above().offset((Vec3i)GadgetNBT.getRelativePaste(gadget)), gadget, true) : BuildingUtils.exchange(context.level(), context.player(), buildList, GadgetCopyPaste.getHitPos(context).above().offset((Vec3i)GadgetNBT.getRelativePaste(gadget)), gadget, true, false);
                GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
                return InteractionResultHolder.success((Object)gadget);
            }
            return InteractionResultHolder.pass((Object)gadget);
        }
        GadgetNBT.setCopyStartPos(gadget, context.pos());
        this.buildAndStore(context, gadget);
        return InteractionResultHolder.success((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (mode.getId().getPath().equals("copy")) {
            GadgetNBT.setCopyEndPos(gadget, context.pos());
            this.buildAndStore(context, gadget);
        } else if (!mode.equals(new Paste())) {
            return InteractionResultHolder.pass((Object)gadget);
        }
        return InteractionResultHolder.success((Object)gadget);
    }

    public void buildAndStore(ItemActionContext context, ItemStack gadget) {
        ArrayList<StatePos> buildList = new Copy().collect(context.hitResult().getDirection(), context.player(), context.pos(), Blocks.AIR.defaultBlockState());
        UUID uuid = GadgetNBT.getUUID(gadget);
        GadgetNBT.setCopyUUID(gadget);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().level().getServer()).overworld());
        bg2Data.addToCopyPaste(uuid, buildList);
        context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copyblocks", (Object[])new Object[]{buildList.size()}), true);
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.COPYPASTE;
    }
}

