/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.screen.widgets.ScrollingMaterialList;
import com.google.common.collect.Lists;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class MaterialListGUI
extends Screen {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"buildinggadgets2", (String)"textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    private int backgroundX;
    private int backgroundY;
    private ItemStack gadget;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ScrollingMaterialList scrollingList;
    private Button buttonClose;
    private Button buttonSortingModes;
    private Button buttonCopyList;

    public MaterialListGUI(ItemStack itemStack) {
        super((Component)Component.translatable((String)"buildinggadgets2.screen.componentslist"));
        this.gadget = itemStack;
    }

    public void init() {
        this.backgroundX = MaterialListGUI.getXForAlignedCenter(0, this.width, 256);
        this.backgroundY = MaterialListGUI.getYForAlignedCenter(0, this.height, 200);
        this.scrollingList = new ScrollingMaterialList(this, this.getWindowLeftX(), this.getWindowTopY() + 16, this.getWindowWidth(), this.getWindowHeight() - 16 - 32, this.gadget);
        this.setFocused((GuiEventListener)this.scrollingList);
        this.addRenderableWidget((GuiEventListener)this.scrollingList);
        int buttonY = this.getWindowBottomY() - 26;
        this.buttonClose = Button.builder((Component)Component.translatable((String)"buildinggadgets2.screen.close"), b -> this.getMinecraft().player.closeContainer()).pos(0, buttonY).size(0, 20).build();
        this.buttonSortingModes = Button.builder((Component)this.scrollingList.getSortingMode().getTranslatable(), button -> {
            this.scrollingList.setSortingMode(this.scrollingList.getSortingMode().next());
            this.buttonSortingModes.setMessage(this.scrollingList.getSortingMode().getTranslatable());
        }).pos(0, buttonY).size(0, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonSortingModes);
        this.addRenderableWidget((GuiEventListener)this.buttonClose);
        this.calculateButtonsWidthAndX();
    }

    protected void renderBlurredBackground(float p_330683_) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float particleTicks) {
        guiGraphics.blit(BACKGROUND_TEXTURE, this.backgroundX, this.backgroundY, 0, 0, 256, 200);
        super.render(guiGraphics, mouseX, mouseY, particleTicks);
        if (this.scrollingList.hoveringText != null) {
            guiGraphics.renderTooltip(this.font, Lists.transform(this.scrollingList.hoveringText, Component::getVisualOrderText), mouseX, mouseY);
            this.scrollingList.hoveringText = null;
        }
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = (int)this.children().stream().filter(e -> e instanceof Button).count();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (GuiEventListener widget : this.children()) {
            if (!(widget instanceof Button)) continue;
            Button btn = (Button)widget;
            btn.setWidth(buttonWidth);
            btn.setX(nextX);
            nextX += buttonWidth + 4;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public ItemStack getTemplateItem() {
        return this.gadget;
    }

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static void renderTextVerticalCenter(GuiGraphics guiGraphics, String text, int leftX, int rightX, int top, int bottom, int color) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int y = MaterialListGUI.getYForAlignedCenter(top, bottom, 9);
        MaterialListGUI.renderScrollingString(guiGraphics, fontRenderer, (Component)Component.literal((String)text), leftX, y, rightX, color);
    }

    public static void renderTextHorizontalRight(GuiGraphics guiGraphics, String text, int right, int y, int color) {
        Font fontRenderer = Minecraft.getInstance().font;
        int x = MaterialListGUI.getXForAlignedRight(right, fontRenderer.width(text));
        guiGraphics.drawString(fontRenderer, text, x, y, color, false);
    }

    protected static void renderScrollingString(GuiGraphics graphics, Font fontRenderer, Component text, int xStart, int yStart, int xEnd, int textColor) {
        int textWidth = fontRenderer.width((FormattedText)text);
        Objects.requireNonNull(fontRenderer);
        int yEnd = yStart + 9;
        int maxRenderWidth = xEnd - xStart;
        if (textWidth > maxRenderWidth) {
            int textOverflow = textWidth - maxRenderWidth;
            double currentTime = (double)Util.getMillis() / 1000.0;
            double scrollDuration = Math.max((double)textOverflow * 0.5, 3.0);
            double oscillation = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTime / scrollDuration)) / 2.0 + 0.5;
            double scrollOffset = Mth.lerp((double)oscillation, (double)0.0, (double)textOverflow);
            graphics.enableScissor(xStart, yStart, xEnd, yEnd);
            graphics.drawString(fontRenderer, text, xStart - (int)scrollOffset, yStart, textColor);
            graphics.disableScissor();
        } else {
            graphics.drawString(fontRenderer, text, xStart, yStart, textColor, false);
        }
    }

    public static boolean isPointInBox(double x, double y, int bx, int by, int width, int height) {
        return x >= (double)bx && y >= (double)by && x < (double)(bx + width) && y < (double)(by + height);
    }
}

