/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.foundationgames.automobility.platform.Platform;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class AutomobilityClientResourceDumper {
    public static final Path DUMP_DIR = Platform.get().getGameDir().resolve("automobility_dump");
    public static final Gson GSON = new Gson();

    public static <R> void dumpDynamicRegistry(HolderLookup.Provider registries, ResourceKey<Registry<R>> key, Codec<R> codec) throws IOException {
        Optional registryMaybe = registries.lookup(key);
        if (registryMaybe.isPresent()) {
            HolderLookup.RegistryLookup registry = (HolderLookup.RegistryLookup)registryMaybe.get();
            ResourceLocation regId = key.location();
            String dumpRoot = "data";
            String subFolder = regId.getNamespace() + "/" + regId.getPath();
            for (Holder.Reference e : registry.listElements().toList()) {
                ResourceLocation location = e.key().location();
                AutomobilityClientResourceDumper.dumpJsonResource(dumpRoot, subFolder, location, e.value(), codec);
            }
        }
    }

    public static <R> void dumpJsonResource(String root, String subfolder, ResourceLocation location, R resource, Codec<R> codec) throws IOException {
        DataResult result;
        Path file = DUMP_DIR.resolve(root).resolve(location.getNamespace()).resolve(subfolder).resolve(location.getPath() + ".json");
        Path folder = file.getParent();
        if (!Files.exists(folder, new LinkOption[0])) {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        if ((result = codec.encode(resource, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject())).isSuccess()) {
            JsonElement json = (JsonElement)result.getOrThrow();
            try (JsonWriter writer = GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
                writer.setIndent("    ");
                GSON.toJson(json, writer);
            }
        }
    }
}

