/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.neoforge;

import com.mojang.serialization.Codec;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.neoforge.NeoForgePlatform;
import io.github.foundationgames.automobility.neoforge.network.NeoForgeNetworking;
import io.github.foundationgames.automobility.util.DefaultRegistrar;
import io.github.foundationgames.automobility.util.RegistryQueue;
import io.github.foundationgames.automobility.util.network.AutomobilityPacketPayload;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="automobility")
@EventBusSubscriber(modid="automobility", bus=EventBusSubscriber.Bus.MOD)
public class AutomobilityNeoForge {
    public AutomobilityNeoForge() {
        NeoForgePlatform.init();
        Automobility.init();
    }

    @SubscribeEvent
    public static void registerNetworking(RegisterPayloadHandlersEvent evt) {
        PayloadRegistrar reg = evt.registrar("0.5");
        reg.playBidirectional(AutomobilityPacketPayload.TYPE, AutomobilityPacketPayload.STREAM_CODEC, NeoForgeNetworking.HANDLER);
    }

    @SubscribeEvent
    public static void registerRegistries(final DataPackRegistryEvent.NewRegistry evt) {
        Automobility.initDynamicRegistries(new Automobility.DynamicRegistryRegistrar(){

            @Override
            public <T> void accept(ResourceKey<Registry<T>> key, Codec<T> codec, DefaultRegistrar<T> defaults) {
                evt.dataPackRegistry(key, codec, codec);
            }
        });
    }

    @SubscribeEvent
    public static void generateData(GatherDataEvent evt) {
        final RegistrySetBuilder regset = new RegistrySetBuilder();
        Automobility.initDynamicRegistries(new Automobility.DynamicRegistryRegistrar(){

            @Override
            public <T> void accept(ResourceKey<Registry<T>> key, Codec<T> codec, DefaultRegistrar<T> defaults) {
                regset.add(key, bs -> defaults.bootstrap((arg_0, arg_1) -> ((BootstrapContext)bs).register(arg_0, arg_1)));
            }
        });
        evt.getGenerator().addProvider(true, output -> new DatapackBuiltinEntriesProvider(output, evt.getLookupProvider(), regset, Set.of("automobility")));
    }

    @SubscribeEvent
    public static void registerAll(RegisterEvent evt) {
        if (evt.getRegistry() == NeoForgeRegistries.ENTITY_DATA_SERIALIZERS) {
            for (Map.Entry<ResourceLocation, EntityDataSerializer<?>> e : NeoForgePlatform.INSTANCE.dataSerializers.entrySet()) {
                evt.register(NeoForgeRegistries.ENTITY_DATA_SERIALIZERS.key(), e.getKey(), e::getValue);
            }
        }
        AutomobilityNeoForge.register(BuiltInRegistries.BLOCK, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.BLOCK_ENTITY_TYPE, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.DATA_COMPONENT_TYPE, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.ITEM, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.ENTITY_TYPE, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.PARTICLE_TYPE, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.SOUND_EVENT, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.MENU, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.RECIPE_TYPE, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.RECIPE_SERIALIZER, evt);
        AutomobilityNeoForge.register(BuiltInRegistries.CREATIVE_MODE_TAB, evt);
    }

    public static <T> void register(Registry<T> registry, RegisterEvent evt) {
        if (registry == evt.getRegistry()) {
            for (RegistryQueue.Entry entry : RegistryQueue.getQueue(registry)) {
                evt.register(registry.key(), entry.rl(), entry.entry()::create);
            }
        }
    }
}

