/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.entity.AutopilotSignBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AutopilotSignBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape FLOOR_SHAPE = AutopilotSignBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    public static final VoxelShape CEILING_SHAPE = AutopilotSignBlock.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape STANDING_SHAPE = AutopilotSignBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)7);
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final MapCodec<AutopilotSignBlock> CODEC = AutopilotSignBlock.simpleCodec(AutopilotSignBlock::new);

    public AutopilotSignBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue(TYPE, (Comparable)((Object)Type.STANDING_RIGHT))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ROTATION, TYPE, POWERED, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Type type = Type.STANDING_RIGHT;
        Direction face = ctx.getClickedFace();
        if (face == Direction.DOWN) {
            type = Type.CEILING;
        } else if (face == Direction.UP && ctx.getNearestLookingDirection() == Direction.DOWN) {
            type = Type.FLOOR;
        }
        int yaw = (int)(382.5 + (double)ctx.getPlayer().getYRot());
        int rotState = Math.floorMod(yaw * 8 / 360, 8);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)type))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotState))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos()).is(Blocks.WATER)));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return switch (((Type)((Object)state.getValue(TYPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> AutopilotSignBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
            case 2 -> level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
            case 3 -> level.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos.above(), Direction.DOWN);
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch (((Type)((Object)state.getValue(TYPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> STANDING_SHAPE;
            case 2 -> FLOOR_SHAPE;
            case 3 -> CEILING_SHAPE;
        };
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean powered = level.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Type type;
        if (player.mayBuild() && (type = (Type)((Object)state.getValue(TYPE))).standing()) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            type = type == Type.STANDING_LEFT ? Type.STANDING_RIGHT : Type.STANDING_LEFT;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)type)));
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public Vec3 getPathDir(BlockState state) {
        double x = switch ((Integer)state.getValue((Property)ROTATION)) {
            default -> 0.0;
            case 1, 2, 3 -> 1.0;
            case 5, 6, 7 -> -1.0;
        };
        double z = switch ((Integer)state.getValue((Property)ROTATION)) {
            default -> 0.0;
            case 3, 4, 5 -> 1.0;
            case 0, 1, 7 -> -1.0;
        };
        double ax = switch (((Type)((Object)state.getValue(TYPE))).ordinal()) {
            case 1 -> -z;
            case 0 -> z;
            default -> x;
        };
        double az = switch (((Type)((Object)state.getValue(TYPE))).ordinal()) {
            case 1 -> x;
            case 0 -> -x;
            default -> z;
        };
        return new Vec3(ax, 0.0, az).normalize();
    }

    public Heading getHeading(BlockState state, BlockPos pos) {
        Vec3 planeOrigin;
        Vec3 dir = this.getPathDir(state);
        Type type = (Type)((Object)state.getValue(TYPE));
        Vec3 planeNormal = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> new Vec3(0.0, 1.0, 0.0);
            case 3 -> new Vec3(0.0, -1.0, 0.0);
            case 1 -> new Vec3(dir.z(), 0.0, -dir.x());
            case 0 -> new Vec3(-dir.z(), 0.0, dir.x());
        };
        Vec3 origin = Vec3.atCenterOf((Vec3i)pos);
        switch (type.ordinal()) {
            case 2: {
                Vec3 vec3 = origin.add(0.0, -0.5, 0.0);
                break;
            }
            case 3: {
                Vec3 vec3 = origin.add(0.0, 0.5, 0.0);
                break;
            }
            default: {
                Vec3 vec3 = planeOrigin = origin;
            }
        }
        if (type.standing()) {
            origin = origin.add(planeNormal.scale(1.5));
        }
        return new Heading(origin, dir, planeOrigin, planeNormal, (Boolean)state.getValue((Property)POWERED));
    }

    public double getDetectBoxOffset(BlockState state) {
        return ((Type)((Object)state.getValue(TYPE))).standing() ? 7.5 : 2.0;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutopilotSignBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return AutopilotSignBlock.createTickerHelper(type, AutomobilityBlocks.AUTOPILOT_SIGN_ENTITY.require(), AutopilotSignBlockEntity::tick);
        }
        return super.getTicker(level, state, type);
    }

    public static enum Type implements StringRepresentable
    {
        STANDING_LEFT("standing_left"),
        STANDING_RIGHT("standing_right"),
        FLOOR("floor"),
        CEILING("ceiling");

        public final String id;

        private Type(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }

        public boolean standing() {
            return this == STANDING_LEFT || this == STANDING_RIGHT;
        }
    }

    public record Heading(Vec3 origin, Vec3 dir, Vec3 planeOrigin, Vec3 limitPlane, boolean stop) {
        public static final Codec<Heading> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Vec3.CODEC.fieldOf("path_origin").forGetter(Heading::origin), (App)Vec3.CODEC.fieldOf("path_dir").forGetter(Heading::origin), (App)Vec3.CODEC.fieldOf("plane_origin").forGetter(Heading::origin), (App)Vec3.CODEC.fieldOf("plane_normal").forGetter(Heading::origin), (App)Codec.BOOL.fieldOf("stop").forGetter(Heading::stop)).apply((Applicative)inst, Heading::new));

        public boolean inFrontOfLimitPlane(Vec3 pos) {
            Vec3 originToPos = pos.subtract(this.planeOrigin());
            return originToPos.dot(this.limitPlane()) >= 0.0;
        }

        public boolean withinReasonableDistance(Vec3 pos) {
            return this.origin().distanceToSqr(pos) < 65536.0;
        }

        public Vec3 pathToPath(Vec3 pos) {
            Vec3 originToPos = pos.subtract(this.origin());
            return originToPos.cross(this.dir()).cross(this.dir()).reverse();
        }

        public Tag toNbt() {
            return (Tag)CODEC.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow();
        }

        public static Heading fromNbt(CompoundTag tag) {
            return CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).map(Pair::getFirst).result().orElse(null);
        }
    }
}

