/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.front;

import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.BaseHarvesterFrontAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CropHarvesterFrontAttachment
extends BaseHarvesterFrontAttachment {
    public CropHarvesterFrontAttachment(FrontAttachmentType<?> type, AutomobileEntity automobile) {
        super(type, automobile);
    }

    @Override
    public boolean canHarvest(BlockState state) {
        CropBlock crop;
        Block block = state.getBlock();
        return block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state);
    }

    @Override
    public void onBlockHarvested(BlockState state, BlockPos pos, List<ItemStack> drops) {
        boolean replanted = false;
        Vec3 dropPos = this.pos();
        Level world = this.world();
        for (ItemStack drop : drops) {
            BlockItem item;
            BlockState newState;
            Item item2;
            if (!replanted && (item2 = drop.getItem()) instanceof BlockItem && (newState = (item = (BlockItem)item2).getBlock().defaultBlockState()).canSurvive((LevelReader)world, pos)) {
                world.setBlockAndUpdate(pos, newState);
                drop.shrink(1);
                replanted = true;
            }
            if (drop.isEmpty()) continue;
            this.dropOrTransfer(drop, dropPos);
        }
    }
}

