/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.front;

import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class BaseHarvesterFrontAttachment
extends FrontAttachment {
    private final BlockPos.MutableBlockPos blockIter = new BlockPos.MutableBlockPos();
    private Vec3 lastPos = null;

    public BaseHarvesterFrontAttachment(FrontAttachmentType<?> type, AutomobileEntity automobile) {
        super(type, automobile);
    }

    @Override
    public void tick() {
        Level level;
        super.tick();
        Vec3 pos = this.pos();
        if (this.canModifyBlocks() && this.lastPos != null && this.lastPos.subtract(pos).length() > 0.03 && (level = this.world()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            this.harvest(pos, world);
        }
        this.lastPos = pos;
    }

    public void harvest(Vec3 pos, ServerLevel world) {
        int minX = (int)Math.floor(pos.x - 0.5);
        int maxX = (int)Math.floor(pos.x + 0.5);
        int minZ = (int)Math.floor(pos.z - 0.5);
        int maxZ = (int)Math.floor(pos.z + 0.5);
        int y = (int)Math.floor(pos.y + 0.25);
        AutomobileEntity entity = this.automobile;
        if (this.automobile.isVehicle()) {
            entity = this.automobile.getFirstPassenger();
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.blockIter.set(x, y, z);
                BlockState state = world.getBlockState((BlockPos)this.blockIter);
                if (!this.canHarvest(state)) continue;
                List stacks = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)this.blockIter, null, (Entity)entity, (ItemStack)ItemStack.EMPTY);
                world.destroyBlock((BlockPos)this.blockIter, false);
                this.onBlockHarvested(state, (BlockPos)this.blockIter, stacks);
            }
        }
    }

    public abstract boolean canHarvest(BlockState var1);

    public abstract void onBlockHarvested(BlockState var1, BlockPos var2, List<ItemStack> var3);
}

