/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import fuzs.visualworkbench.world.level.block.entity.WorkbenchVisualsProvider;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class CraftingTableBlockEntityRenderer<T extends BlockEntity & WorkbenchVisualsProvider>
implements BlockEntityRenderer<T> {
    private final ItemRenderer itemRenderer;

    public CraftingTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        packedLight = blockEntity.getLevel() != null ? LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().above()) : 0xF000F0;
        for (int i = 0; i < ((Container)blockEntity).getContainerSize(); ++i) {
            ItemStack itemStack = ((Container)blockEntity).getItem(i);
            if (itemStack.isEmpty()) continue;
            this.renderIngredientItem(blockEntity, partialTick, poseStack, multiBufferSource, packedLight, packedOverlay, i, itemStack);
        }
        ItemStack itemStack = ((WorkbenchVisualsProvider)blockEntity).getCraftingResult();
        if (!itemStack.isEmpty()) {
            this.renderResultItem(itemStack, blockEntity.getLevel(), (float)((WorkbenchVisualsProvider)blockEntity).getAnimationController().ticks + partialTick, poseStack, multiBufferSource, packedLight);
        }
    }

    private void renderIngredientItem(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, int i, ItemStack itemStack) {
        poseStack.pushPose();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).flatRendering) {
            this.setupFlatRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController(), partialTick, poseStack, itemStack, i);
        } else {
            this.setupFloatingRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController(), partialTick, poseStack, itemStack, i);
        }
        this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, multiBufferSource, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong() + i);
        poseStack.popPose();
    }

    private void setupFloatingRenderer(CraftingTableAnimationController animationController, float partialTick, PoseStack poseStack, ItemStack itemStack, int index) {
        float shift = (float)Math.abs(((double)((float)animationController.ticks + partialTick) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        BakedModel model = this.itemRenderer.getModel(itemStack, null, null, 0);
        boolean blockItem = model.isGui3d();
        poseStack.translate(0.5, (double)shift, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animationController.currentAngle, (float)animationController.nextAngle)));
        poseStack.translate((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        float scale = blockItem ? 0.24f : 0.18f;
        poseStack.scale(scale, scale, scale);
    }

    private void setupFlatRenderer(CraftingTableAnimationController animationController, float partialTick, PoseStack poseStack, ItemStack itemStack, int index) {
        BakedModel bakedModel = this.itemRenderer.getModel(itemStack, null, null, 0);
        boolean gui3d = bakedModel.isGui3d();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animationController.currentAngle, (float)animationController.nextAngle)));
        poseStack.translate((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, gui3d ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        float scale = gui3d ? 0.25f : 0.175f;
        poseStack.scale(scale, scale, scale);
    }

    private void renderResultItem(ItemStack itemStack, @Nullable Level level, float time, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (!((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).renderResult) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.15f, 0.5f);
        BakedModel model = this.itemRenderer.getModel(itemStack, level, null, 0);
        float hoverOffset = Mth.sin((float)(time / 10.0f)) * 0.04f + 0.1f;
        float modelYScale = model.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        poseStack.translate(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        poseStack.mulPose(Axis.YP.rotation(time / 20.0f));
        if (!model.isGui3d()) {
            poseStack.scale(0.75f, 0.75f, 0.75f);
        }
        this.itemRenderer.render(itemStack, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, packedLight, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
    }
}

