/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.handler;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.visualworkbench.handler.BlockConversionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockModelHandler {
    private static final Supplier<Map<ModelResourceLocation, ModelResourceLocation>> MODEL_LOCATIONS = Suppliers.memoize(() -> (Map)BlockConversionHandler.getBlockConversions().entrySet().stream().flatMap(entry -> BlockModelHandler.convertAllBlockStates((Block)entry.getValue(), (Block)entry.getKey()).entrySet().stream()).collect(Util.toMap()));

    public static void onLoadComplete() {
        for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
            RenderType renderType = ClientAbstractions.INSTANCE.getRenderType((Block)entry.getKey());
            ClientAbstractions.INSTANCE.registerRenderType((Block)entry.getValue(), renderType);
        }
    }

    public static EventResultHolder<UnbakedModel> onModifyUnbakedModel(ModelResourceLocation modelLocation, Supplier<UnbakedModel> unbakedModel, Function<ModelResourceLocation, UnbakedModel> modelGetter, BiConsumer<ResourceLocation, UnbakedModel> modelAdder) {
        if (MODEL_LOCATIONS.get().containsKey(modelLocation)) {
            return EventResultHolder.interrupt((Object)modelGetter.apply(MODEL_LOCATIONS.get().get(modelLocation)));
        }
        return EventResultHolder.pass();
    }

    private static Map<ModelResourceLocation, ModelResourceLocation> convertAllBlockStates(Block oldBlock, Block newBlock) {
        HashMap modelLocations = Maps.newHashMap();
        for (BlockState oldBlockState : oldBlock.getStateDefinition().getPossibleStates()) {
            BlockState newBlockState = BlockModelHandler.convertBlockState((StateDefinition<Block, BlockState>)newBlock.getStateDefinition(), oldBlockState);
            modelLocations.put(BlockModelShaper.stateToModelLocation((BlockState)oldBlockState), BlockModelShaper.stateToModelLocation((BlockState)newBlockState));
        }
        return modelLocations;
    }

    private static BlockState convertBlockState(StateDefinition<Block, BlockState> newStateDefinition, BlockState oldBlockState) {
        BlockState newBlockState = (BlockState)newStateDefinition.any();
        for (Map.Entry entry : oldBlockState.getValues().entrySet()) {
            newBlockState = BlockModelHandler.setBlockStateValue((Property)entry.getKey(), (Comparable)entry.getValue(), arg_0 -> newStateDefinition.getProperty(arg_0), newBlockState);
        }
        return newBlockState;
    }

    private static <T extends Comparable<T>, V extends T> BlockState setBlockStateValue(Property<?> oldProperty, Comparable<?> oldValue, Function<String, @Nullable Property<?>> propertyGetter, BlockState blockState) {
        Property<?> newProperty = propertyGetter.apply(oldProperty.getName());
        if (newProperty != null) {
            return (BlockState)blockState.setValue(newProperty, oldValue);
        }
        return blockState;
    }
}

