/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import mekanism.common.attachments.FrequencyAware;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IColoredItem {
    @Nullable
    default public DataComponentType<? extends FrequencyAware<?>> getFrequencyComponent() {
        return null;
    }

    default public <FREQ extends Frequency> void syncColorWithFrequency(ItemStack stack) {
        DataComponentType<? extends FrequencyAware<?>> frequencyComponent = this.getFrequencyComponent();
        if (frequencyComponent != null) {
            FrequencyAware frequencyAware = (FrequencyAware)stack.getOrDefault(frequencyComponent, FrequencyAware.none());
            Object FREQ = frequencyAware.getFrequency(stack, frequencyComponent);
            if (FREQ instanceof IColorableFrequency) {
                IColorableFrequency frequency = (IColorableFrequency)FREQ;
                stack.set(MekanismDataComponents.COLOR, (Object)frequency.getColor());
            } else {
                stack.remove(MekanismDataComponents.COLOR);
            }
        }
    }
}

