/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.chemical;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.LongPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.chemical.ChemicalStackPropertyData;
import net.minecraft.core.RegistryAccess;
import org.jetbrains.annotations.NotNull;

public final class SyncableChemicalStack
implements ISyncableData {
    @NotNull
    private ChemicalStack lastKnownValue;
    private final Supplier<ChemicalStack> getter;
    private final Consumer<ChemicalStack> setter;

    public static SyncableChemicalStack create(IChemicalTank handler) {
        return SyncableChemicalStack.create(handler, false);
    }

    public static SyncableChemicalStack create(IChemicalTank handler, boolean isClient) {
        return SyncableChemicalStack.create(handler::getStack, isClient ? handler::setStackUnchecked : handler::setStack);
    }

    public static SyncableChemicalStack create(Supplier<@NotNull ChemicalStack> getter, Consumer<@NotNull ChemicalStack> setter) {
        return new SyncableChemicalStack(getter, setter);
    }

    public SyncableChemicalStack(Supplier<ChemicalStack> getter, Consumer<ChemicalStack> setter) {
        this.getter = getter;
        this.setter = setter;
        this.lastKnownValue = ChemicalStack.EMPTY;
    }

    public ChemicalStack get() {
        return this.getter.get();
    }

    public void set(ChemicalStack value) {
        this.setter.accept(value);
    }

    public void set(long amount) {
        ChemicalStack stack = this.get();
        if (!stack.isEmpty()) {
            this.set(stack.copyWithAmount(amount));
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        ChemicalStack value = this.get();
        boolean sameType = ChemicalStack.isSameChemical(value, this.lastKnownValue);
        if (!sameType || value.getAmount() != this.lastKnownValue.getAmount()) {
            this.lastKnownValue = value.copy();
            return sameType ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }

    @Override
    public PropertyData getPropertyData(RegistryAccess registryAccess, short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new LongPropertyData(property, this.get().getAmount());
        }
        return new ChemicalStackPropertyData(property, this.get().copy());
    }
}

