/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical;

import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.util.RegistryUtils;

public abstract class BaseCrTChemicalStack
implements ICrTChemicalStack {
    protected final ChemicalStack stack;
    protected final Function<ChemicalStack, ICrTChemicalStack> stackConverter;

    public BaseCrTChemicalStack(ChemicalStack stack, Function<ChemicalStack, ICrTChemicalStack> stackConverter) {
        this.stack = stack;
        this.stackConverter = stackConverter;
    }

    protected StringBuilder getBracket() {
        return new StringBuilder().append('<').append("chemical").append(':').append(RegistryUtils.getName(this.stack.getChemicalHolder(), MekanismAPI.CHEMICAL_REGISTRY)).append('>');
    }

    public String getCommandString() {
        StringBuilder builder = this.getBracket();
        if (!this.stack.isEmpty() && this.stack.getAmount() != 1L) {
            builder.append(" * ").append(this.stack.getAmount());
        }
        return builder.toString();
    }

    @Override
    public ICrTChemicalStack copy() {
        return this.stackConverter.apply(this.stack.copy());
    }

    @Override
    public ChemicalStack getInternal() {
        return this.stack;
    }

    public String toString() {
        return this.getCommandString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.stack.equals(((BaseCrTChemicalStack)o).stack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }
}

