/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collection;
import java.util.List;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeStateFacing
implements AttributeState {
    private final DirectionProperty facingProperty;
    private final FacePlacementType placementType;
    private final boolean canRotate;

    public AttributeStateFacing() {
        this(true);
    }

    public AttributeStateFacing(boolean canRotate) {
        this(BlockStateProperties.HORIZONTAL_FACING, canRotate);
    }

    public AttributeStateFacing(DirectionProperty facingProperty) {
        this(facingProperty, true);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, boolean canRotate) {
        this(facingProperty, FacePlacementType.PLAYER_LOCATION, canRotate);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType) {
        this(facingProperty, placementType, true);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType, boolean canRotate) {
        this.facingProperty = facingProperty;
        this.placementType = placementType;
        this.canRotate = canRotate;
    }

    public boolean canRotate() {
        return this.canRotate;
    }

    public Direction getDirection(BlockState state) {
        return (Direction)state.getValue((Property)this.getFacingProperty());
    }

    public BlockState setDirection(@NotNull BlockState state, Direction newDirection) {
        return this.supportsDirection(newDirection) ? (BlockState)state.setValue((Property)this.getFacingProperty(), (Comparable)newDirection) : state;
    }

    @NotNull
    public DirectionProperty getFacingProperty() {
        return this.facingProperty;
    }

    @NotNull
    public FacePlacementType getPlacementType() {
        return this.placementType;
    }

    public Collection<Direction> getSupportedDirections() {
        return this.getFacingProperty().getPossibleValues();
    }

    public boolean supportsDirection(Direction direction) {
        return this.getSupportedDirections().contains(direction);
    }

    @Override
    public void fillBlockStateContainer(Block block, List<Property<?>> properties) {
        properties.add((Property<?>)this.getFacingProperty());
    }

    @Override
    public BlockState copyStateData(BlockState oldState, BlockState newState) {
        AttributeStateFacing newStateFacingAttribute = Attribute.get(newState, AttributeStateFacing.class);
        if (newStateFacingAttribute != null) {
            DirectionProperty oldFacingProperty = Attribute.getOrThrow(oldState, AttributeStateFacing.class).getFacingProperty();
            newState = (BlockState)newState.setValue((Property)newStateFacingAttribute.getFacingProperty(), (Comparable)((Direction)oldState.getValue((Property)oldFacingProperty)));
        }
        return newState;
    }

    @Override
    @Contract(value="null, _, _, _, _ -> null")
    public BlockState getStateForPlacement(@Nullable BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos pos, @Nullable Player player, @NotNull Direction face) {
        if (state == null) {
            return null;
        }
        AttributeStateFacing blockFacing = Attribute.get(state, AttributeStateFacing.class);
        Direction newDirection = Direction.SOUTH;
        if (blockFacing.getPlacementType() == FacePlacementType.PLAYER_LOCATION) {
            if (blockFacing.supportsDirection(Direction.DOWN) && blockFacing.supportsDirection(Direction.UP)) {
                float rotationPitch = player == null ? 0.0f : player.getXRot();
                int height = Math.round(rotationPitch);
                if (height >= 65) {
                    newDirection = Direction.UP;
                } else if (height <= -65) {
                    newDirection = Direction.DOWN;
                }
            }
            if (newDirection != Direction.DOWN && newDirection != Direction.UP) {
                float placementYaw = player == null ? 0.0f : player.getYRot();
                int side = Mth.floor((double)((double)(placementYaw * 4.0f / 360.0f) + 0.5)) & 3;
                newDirection = switch (side) {
                    case 0 -> Direction.NORTH;
                    case 1 -> Direction.EAST;
                    case 2 -> Direction.SOUTH;
                    case 3 -> Direction.WEST;
                    default -> newDirection;
                };
            }
        } else {
            newDirection = blockFacing.supportsDirection(face) ? face : Direction.NORTH;
        }
        state = blockFacing.setDirection(state, newDirection);
        return state;
    }

    public static BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return AttributeStateFacing.rotate(state, rotation);
    }

    public static BlockState rotate(BlockState state, Rotation rotation) {
        AttributeStateFacing blockFacing = Attribute.get(state, AttributeStateFacing.class);
        if (blockFacing != null && blockFacing.canRotate()) {
            return AttributeStateFacing.rotate(blockFacing, blockFacing.getFacingProperty(), state, rotation);
        }
        return state;
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        AttributeStateFacing blockFacing = Attribute.get(state, AttributeStateFacing.class);
        if (blockFacing != null && blockFacing.canRotate()) {
            DirectionProperty property = blockFacing.getFacingProperty();
            return AttributeStateFacing.rotate(blockFacing, property, state, mirror.getRotation((Direction)state.getValue((Property)property)));
        }
        return state;
    }

    private static BlockState rotate(AttributeStateFacing blockFacing, DirectionProperty property, BlockState state, Rotation rotation) {
        return blockFacing.setDirection(state, rotation.rotate((Direction)state.getValue((Property)property)));
    }

    public static enum FacePlacementType {
        PLAYER_LOCATION,
        SELECTED_FACE;

    }
}

