/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.function.LongSupplier;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.MathUtils;
import mekanism.common.block.attribute.Attribute;
import org.jetbrains.annotations.Nullable;

public class AttributeEnergy
implements Attribute {
    private LongSupplier energyUsage = ConstantPredicates.ZERO_LONG;
    private LongSupplier energyStorage = () -> MathUtils.multiplyClamped(this.energyUsage.getAsLong(), 400L);

    public AttributeEnergy(@Nullable LongSupplier energyUsage, @Nullable LongSupplier energyStorage) {
        if (energyUsage != null) {
            this.energyUsage = energyUsage;
        }
        if (energyStorage != null) {
            this.energyStorage = energyStorage;
        }
    }

    public long getUsage() {
        return this.energyUsage.getAsLong();
    }

    public long getConfigStorage() {
        return this.energyStorage.getAsLong();
    }

    public long getStorage() {
        return Math.max(this.getConfigStorage(), this.getUsage());
    }
}

