/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.IAttachedContainers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ComponentBackedHandler<TYPE, CONTAINER extends INBTSerializable<CompoundTag>, ATTACHED extends IAttachedContainers<TYPE, ATTACHED>>
extends AbstractList<CONTAINER>
implements IContentsListener {
    protected final ItemStack attachedTo;
    private final int totalContainers;
    @Nullable
    private List<CONTAINER> containers;
    private int numNotInitialized;

    protected ComponentBackedHandler(ItemStack attachedTo, int totalContainers) {
        this.attachedTo = attachedTo;
        this.totalContainers = totalContainers;
    }

    protected abstract ContainerType<CONTAINER, ATTACHED, ?> containerType();

    protected ATTACHED getAttached() {
        return this.containerType().getOrEmpty(this.attachedTo);
    }

    protected TYPE getContents(int index) {
        return this.getAttached().getOrDefault(index);
    }

    private List<CONTAINER> containers() {
        if (this.containers == null) {
            this.containers = Arrays.asList(new INBTSerializable[this.totalContainers]);
            this.numNotInitialized = this.totalContainers;
        }
        return this.containers;
    }

    public List<CONTAINER> getContainers() {
        List<CONTAINER> containers = this.containers();
        int size = containers.size();
        for (int i = 0; this.numNotInitialized > 0 && i < size; ++i) {
            if (containers.get(i) != null) continue;
            this.initializeContainer(i);
        }
        return containers;
    }

    private CONTAINER initializeContainer(int index) {
        CONTAINER container = this.containerType().createContainer(this.attachedTo, index);
        this.containers().set(index, container);
        --this.numNotInitialized;
        return container;
    }

    protected CONTAINER getContainer(int index) {
        INBTSerializable container = (INBTSerializable)this.containers().get(index);
        return (CONTAINER)(container == null ? this.initializeContainer(index) : container);
    }

    @Override
    public int size() {
        return this.totalContainers;
    }

    @Override
    public CONTAINER get(int index) {
        return this.getContainer(index);
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    public Iterator<CONTAINER> iterator() {
        return new ContainerIterator();
    }

    private class ContainerIterator
    implements Iterator<CONTAINER> {
        private int cursor = 0;

        private ContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ComponentBackedHandler.this.size();
        }

        @Override
        public CONTAINER next() {
            return ComponentBackedHandler.this.getContainer(this.cursor++);
        }
    }
}

