/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.IBlockEnergyConnector;
import sonar.fluxnetworks.api.energy.IItemEnergyConnector;
import sonar.fluxnetworks.common.integration.energy.FNEnergyConnector;
import sonar.fluxnetworks.common.integration.energy.ForgeEnergyConnector;
import sonar.fluxnetworks.common.integration.energy.GTCEUEnergyConnector;

public final class EnergyUtils {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Energy");
    private static final List<IBlockEnergyConnector> BLOCK_ENERGY_CONNECTORS = new ArrayList<IBlockEnergyConnector>();
    private static final Set<Block> BLOCK_BLACKLIST = new HashSet<Block>();
    private static final List<IItemEnergyConnector> ITEM_ENERGY_CONNECTORS = new ArrayList<IItemEnergyConnector>();
    private static final Set<Item> ITEM_BLACKLIST = new HashSet<Item>();

    private EnergyUtils() {
    }

    public static void register() {
        if (FluxConfig.enableGTCEU && ModList.get().isLoaded("gtceu")) {
            BLOCK_ENERGY_CONNECTORS.add(GTCEUEnergyConnector.INSTANCE);
            ITEM_ENERGY_CONNECTORS.add(GTCEUEnergyConnector.INSTANCE);
        }
    }

    public static void reloadBlacklist(@Nonnull List<String> blockBlacklist, @Nonnull List<String> itemBlacklist) {
        BLOCK_BLACKLIST.clear();
        for (String s : blockBlacklist) {
            if (s == null || s.isEmpty()) continue;
            try {
                Optional block = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)s));
                block.ifPresent(BLOCK_BLACKLIST::add);
            }
            catch (Exception e) {
                FluxNetworks.LOGGER.warn(MARKER, "Block blacklist error: {} has incorrect formatting", (Object)s, (Object)e);
            }
        }
        ITEM_BLACKLIST.clear();
        for (String s : itemBlacklist) {
            if (s == null || s.isEmpty()) continue;
            try {
                Optional item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)s));
                item.ifPresent(ITEM_BLACKLIST::add);
            }
            catch (Exception e) {
                FluxNetworks.LOGGER.warn(MARKER, "Item blacklist error: {} has incorrect formatting", (Object)s, (Object)e);
            }
        }
        FluxNetworks.LOGGER.info(MARKER, "Energy blacklist loaded: {} block entries, {} item entries", (Object)BLOCK_BLACKLIST.size(), (Object)ITEM_BLACKLIST.size());
    }

    @Nullable
    public static IBlockEnergyConnector getConnector(@Nullable BlockEntity target, @Nonnull Direction side) {
        if (target == null) {
            return null;
        }
        if (target.isRemoved()) {
            return null;
        }
        if (target instanceof IFluxDevice) {
            return null;
        }
        if (BLOCK_BLACKLIST.contains(target.getBlockState().getBlock())) {
            return null;
        }
        for (IBlockEnergyConnector connector : BLOCK_ENERGY_CONNECTORS) {
            if (!connector.hasCapability(target, side)) continue;
            return connector;
        }
        return null;
    }

    @Nullable
    public static IItemEnergyConnector getConnector(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.isEmpty()) {
            return null;
        }
        if (ITEM_BLACKLIST.contains(stack.getItem())) {
            return null;
        }
        for (IItemEnergyConnector connector : ITEM_ENERGY_CONNECTORS) {
            if (!connector.hasCapability(stack)) continue;
            return connector;
        }
        return null;
    }

    static {
        BLOCK_ENERGY_CONNECTORS.add(FNEnergyConnector.INSTANCE);
        ITEM_ENERGY_CONNECTORS.add(FNEnergyConnector.INSTANCE);
        BLOCK_ENERGY_CONNECTORS.add(ForgeEnergyConnector.INSTANCE);
        ITEM_ENERGY_CONNECTORS.add(ForgeEnergyConnector.INSTANCE);
    }
}

