/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.util.thread.EffectiveSide;
import sonar.fluxnetworks.api.device.IFluxProvider;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.common.device.TileFluxStorage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemAdminConfigurator
extends Item {
    public ItemAdminConfigurator(Item.Properties props) {
        super(props);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileFluxStorage storage;
        BlockEntity blockEntity;
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown() && FluxPlayerData.isPlayerSuperAdmin((ServerPlayer)player) && (blockEntity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof TileFluxStorage && (storage = (TileFluxStorage)blockEntity).canPlayerAccess(player)) {
            storage.fillUp();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!level.isClientSide) {
            player.openMenu((MenuProvider)new Provider(), buf -> buf.writeBoolean(false));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static class Provider
    implements IFluxProvider {
        @Override
        public int getNetworkID() {
            assert (EffectiveSide.get().isClient());
            return ClientCache.sAdminViewingNetwork;
        }

        @Override
        public void onPlayerOpened(@Nonnull Player player) {
        }

        @Override
        public void onPlayerClosed(@Nonnull Player player) {
        }

        @Nullable
        public FluxMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new FluxMenu(containerId, inventory, this);
        }
    }
}

