/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.EditButton;
import sonar.fluxnetworks.client.gui.popup.PopupNetworkPassword;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.util.FluxUtils;

public class GuiTabSelection
extends GuiTabPages<FluxNetwork> {
    private EditButton mDisconnect;
    public FluxNetwork mSelectedNetwork;

    public GuiTabSelection(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mGridHeight = 13;
        this.mGridPerPage = 9;
        this.mElementWidth = 146;
        this.mElementHeight = 12;
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_SELECTION;
    }

    @Override
    protected void drawBackgroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.mElements.isEmpty()) {
            this.renderNavigationPrompt(gr, FluxTranslate.ERROR_NO_NETWORK, EnumNavigationTab.TAB_CREATE);
        } else {
            String total = FluxTranslate.TOTAL.get() + ": " + this.mElements.size();
            gr.drawString(this.font, total, this.leftPos + 158 - this.font.width(total), this.topPos + 24, 0xFFFFFF);
            String sortBy = FluxTranslate.SORT_BY.get() + ": " + String.valueOf(ChatFormatting.AQUA) + this.mSortType.getTranslatedName();
            gr.drawString(this.font, sortBy, this.leftPos + 19, this.topPos + 24, 0xFFFFFF);
            this.renderNetwork(gr, this.getNetwork().getNetworkName(), this.getNetwork().getNetworkColor(), this.topPos + 8);
        }
    }

    @Override
    public void init() {
        super.init();
        this.mGridStartX = this.leftPos + 15;
        this.mGridStartY = this.topPos + 36;
        this.refreshPages(ClientCache.getAllNetworks());
        if (!this.mElements.isEmpty()) {
            this.mDisconnect = new EditButton(this, this.leftPos + 142, this.topPos + 10, 8, 8, 0, 0, FluxTranslate.BATCH_DISCONNECT_BUTTON.get(), FluxTranslate.BATCH_DISCONNECT_BUTTON.get());
            this.mDisconnect.setClickable(this.getNetwork().isValid());
            this.mButtons.add(this.mDisconnect);
        }
    }

    @Override
    public void renderElement(GuiGraphics gr, FluxNetwork element, int x, int y) {
        boolean locked;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
        boolean selected = this.getNetwork() == element;
        boolean bl = locked = element.getSecurityLevel() != SecurityLevel.PUBLIC;
        if (locked) {
            if (selected) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            GuiTabSelection.blitF(gr, x + 133, y + 1, 10.0f, 10.0f, 384.0f, 256.0f, 64.0f, 64.0f);
        }
        int color = element.getNetworkColor();
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        if (selected) {
            gr.fill(x - 2, y, x - 1, y + this.mElementHeight, -1);
            gr.fill(x + this.mElementWidth + 1, y, x + this.mElementWidth + 2, y + this.mElementHeight, -1);
        }
        this.renderBarAndName(gr, element, x, y, selected);
    }

    protected void renderBarAndName(GuiGraphics gr, FluxNetwork element, int x, int y, boolean selected) {
        GuiTabSelection.blitF(gr, x, y, this.mElementWidth, this.mElementHeight, 0.0f, 352.0f, this.mElementWidth * 2, this.mElementHeight * 2);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gr.drawString(this.font, element.getNetworkName(), x + 4, y + 2, selected ? 0xFFFFFF : 0x606060);
    }

    @Override
    public void renderElementTooltip(GuiGraphics gr, FluxNetwork element, int mouseX, int mouseY) {
        gr.renderComponentTooltip(this.font, this.getElementTooltips(element), mouseX, mouseY);
    }

    protected List<Component> getElementTooltips(@Nonnull FluxNetwork element) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.literal((String)("ID: " + element.getNetworkID())));
        components.add((Component)FluxTranslate.NETWORK_NAME.makeComponent().append(": " + String.valueOf(ChatFormatting.AQUA) + element.getNetworkName()));
        components.add((Component)FluxTranslate.NETWORK_SECURITY.makeComponent().append(": " + String.valueOf(ChatFormatting.GOLD) + element.getSecurityLevel().getName()));
        AccessLevel access = element.getPlayerAccess(this.mPlayer);
        if (access != AccessLevel.BLOCKED) {
            components.add((Component)FluxTranslate.ACCESS.makeComponent().append(": " + access.getFormattedName()));
        }
        if (ClientCache.sWirelessNetwork == element.getNetworkID()) {
            components.add((Component)FluxTranslate.EFFECTIVE_WIRELESS_NETWORK.makeComponent().withStyle(ChatFormatting.YELLOW));
        }
        return components;
    }

    @Override
    protected void onElementClicked(FluxNetwork element, int mouseButton) {
        if (mouseButton == 0) {
            this.mSelectedNetwork = element;
            this.setConnectedNetwork(element, ClientCache.getRecentPassword(element.getNetworkID()));
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0) {
            if (mouseX >= (double)(this.leftPos + 45) && mouseX < (double)(this.leftPos + 75) && mouseY >= (double)(this.topPos + 24) && mouseY < (double)(this.topPos + 32)) {
                this.mSortType = (GuiTabPages.SortType)FluxUtils.cycle((Enum)this.mSortType, (Enum[])GuiTabPages.SortType.values());
                this.sortGrids(this.mSortType);
                this.refreshCurrentPage();
                return true;
            }
            if (this.mElements.isEmpty()) {
                return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_CREATE);
            }
        }
        return false;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button == this.mDisconnect) {
            this.setConnectedNetwork(FluxNetwork.INVALID, "");
        }
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (key == 4) {
            if (code == -2) {
                this.openPopup(new PopupNetworkPassword(this));
            } else if (code == -1) {
                if (this.mSelectedNetwork != null) {
                    Object p;
                    Object object = this.getCurrentPopup();
                    if (object instanceof PopupNetworkPassword) {
                        p = (PopupNetworkPassword)((Object)object);
                        ClientCache.updateRecentPassword(this.mSelectedNetwork.getNetworkID(), p.mPassword.getValue());
                    }
                    if ((object = ((FluxMenu)this.menu).mProvider) instanceof ItemFluxConfigurator.Provider) {
                        p = (ItemFluxConfigurator.Provider)object;
                        FluxDeviceConfigComponent component = (FluxDeviceConfigComponent)((ItemFluxConfigurator.Provider)p).mStack.getOrDefault(FluxDataComponents.FLUX_CONFIG, (Object)FluxDeviceConfigComponent.EMPTY);
                        ((ItemFluxConfigurator.Provider)p).mStack.set(FluxDataComponents.FLUX_CONFIG, (Object)component.withNetwork(this.mSelectedNetwork.getNetworkID()));
                    }
                }
                this.closePopup();
                this.mSelectedNetwork = null;
            }
        } else if (key == 8) {
            this.refreshPages(ClientCache.getAllNetworks());
        }
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.mDisconnect != null) {
            this.mDisconnect.setClickable(this.getNetwork().isValid());
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.mElements.sort(Comparator.comparing(FluxNetwork::getNetworkID));
                break;
            }
            case NAME: {
                this.mElements.sort(Comparator.comparing(FluxNetwork::getNetworkName));
            }
        }
    }
}

