/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.mui.MUIIntegration;

public class FluxEditBox
extends EditBox {
    private final Font mFont;
    private final String mHeader;
    private final int mHeaderWidth;
    private String mOrigin;
    private boolean mHexOnly;
    private boolean mDigitsOnly;
    private long mMaxValue = Integer.MAX_VALUE;
    private boolean mAllowNegatives = false;
    private int mOutlineColor = -4934476;

    private FluxEditBox(String header, Font font, int x, int y, int totalWidth, int height, int headerWidth) {
        super(font, x + headerWidth, y, totalWidth - headerWidth, height, CommonComponents.EMPTY);
        this.mHeader = header;
        this.mHeaderWidth = headerWidth;
        this.mFont = font;
    }

    @Nonnull
    public static FluxEditBox create(String header, Font font, int x, int y, int width, int height) {
        return new FluxEditBox(header, font, x, y, width, height, font.width(header));
    }

    public int getIntegerFromText(boolean allowNegatives) {
        if (this.getValue().isEmpty() || this.getValue().equals("-")) {
            return 0;
        }
        int parseInt = Integer.parseInt(this.getValue());
        return allowNegatives ? parseInt : Math.max(parseInt, 0);
    }

    public long getLongFromText(boolean allowNegatives) {
        if (this.getValue().isEmpty() || this.getValue().equals("-")) {
            return 0L;
        }
        long parseLong = Long.parseLong(this.getValue());
        return allowNegatives ? parseLong : Math.max(parseLong, 0L);
    }

    public int getIntegerFromHex() {
        return Integer.parseInt(this.getValue(), 16);
    }

    public void renderWidget(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        if (this.isVisible()) {
            if (GuiFocusable.useModernDesign()) {
                MUIIntegration.drawEditBoxBorder(gr, this.getX() - this.mHeaderWidth, this.getY(), this.width + this.mHeaderWidth, this.height, this.mOutlineColor);
            } else {
                gr.fill(this.getX() - this.mHeaderWidth, this.getY(), this.getX() + this.width, this.getY() + this.height, 0x30000000);
                gr.fill(this.getX() - this.mHeaderWidth - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY(), this.mOutlineColor);
                gr.fill(this.getX() - this.mHeaderWidth - 1, this.getY() + this.height, this.getX() + this.width + 1, this.getY() + this.height + 1, this.mOutlineColor);
                gr.fill(this.getX() - this.mHeaderWidth - 1, this.getY(), this.getX() - this.mHeaderWidth, this.getY() + this.height, this.mOutlineColor);
                gr.fill(this.getX() + this.width, this.getY(), this.getX() + this.width + 1, this.getY() + this.height, this.mOutlineColor);
            }
        }
        gr.pose().pushPose();
        int dy = (this.height - 8) / 2;
        gr.pose().translate(4.0f, (float)dy, 0.0f);
        this.setBordered(false);
        super.renderWidget(gr, mouseX, mouseY, deltaTicks);
        gr.drawString(this.mFont, this.mHeader, this.getX() - this.mHeaderWidth, this.getY(), this.mOutlineColor);
        gr.pose().popPose();
    }

    public void insertText(@Nonnull String textToWrite) {
        char c;
        int i;
        if (this.mDigitsOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (Character.isDigit(c)) continue;
                if (this.getValue().isEmpty()) {
                    if (c == '-') continue;
                    return;
                }
                return;
            }
        }
        if (this.mHexOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (c != '-') continue;
                return;
            }
            String origin = this.getValue();
            super.insertText(textToWrite);
            try {
                Integer.parseInt(this.getValue(), 16);
            }
            catch (NumberFormatException ignored) {
                this.setValue(origin);
            }
            return;
        }
        super.insertText(textToWrite);
    }

    public void setFocused(boolean isFocused) {
        if (isFocused) {
            if (this.mDigitsOnly) {
                this.mOrigin = this.getValue();
            }
        } else if (this.isFocused() && this.mDigitsOnly) {
            try {
                this.setValue(String.valueOf(this.getValidLong()));
            }
            catch (NumberFormatException ignored) {
                this.setValue(this.mOrigin);
            }
        }
        super.setFocused(isFocused);
    }

    public long getValidLong() {
        return Math.min(this.getLongFromText(this.mAllowNegatives), this.mMaxValue);
    }

    public int getValidInt() {
        return (int)Math.min(this.getValidLong(), Integer.MAX_VALUE);
    }

    public FluxEditBox setOutlineColor(int color) {
        this.mOutlineColor = color;
        return this;
    }

    public int getOutlineColor() {
        return this.mOutlineColor;
    }

    public FluxEditBox setTextInvisible() {
        this.setFormatter(FluxEditBox::getInvisibleText);
        return this;
    }

    @Nonnull
    public static FormattedCharSequence getInvisibleText(String string, int cursorPos) {
        return FormattedCharSequence.forward((String)"\u2022".repeat(string.length()), (Style)Style.EMPTY);
    }

    public FluxEditBox setDigitsOnly() {
        this.mDigitsOnly = true;
        return this;
    }

    public FluxEditBox setAllowNegatives(boolean allowNegatives) {
        this.mAllowNegatives = allowNegatives;
        return this;
    }

    public FluxEditBox setMaxValue(long max) {
        this.mMaxValue = max;
        return this;
    }

    public FluxEditBox setHexOnly() {
        this.mHexOnly = true;
        return this;
    }
}

