/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.design;

import icyllis.modernui.text.InputFilter;
import icyllis.modernui.text.Spanned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sonar.fluxnetworks.common.util.FluxUtils;

@OnlyIn(value=Dist.CLIENT)
public class PasswordFilter
extends InputFilter.LengthFilter {
    private static final PasswordFilter sInstance = new PasswordFilter();

    private PasswordFilter() {
        super(16);
    }

    @Nonnull
    public static PasswordFilter getInstance() {
        return sInstance;
    }

    @Nullable
    public CharSequence filter(@Nonnull CharSequence source, int start, int end, @Nonnull Spanned dest, int dstart, int dend) {
        int i;
        CharSequence superResult = super.filter(source, start, end, dest, dstart, dend);
        if (superResult != null) {
            return superResult;
        }
        for (i = start; i < end && !FluxUtils.isBadPasswordChar(source.charAt(i)); ++i) {
        }
        if (i == end) {
            return null;
        }
        if (end - start == 1) {
            return "";
        }
        StringBuilder filtered = new StringBuilder();
        filtered.append(source, start, end);
        i -= start;
        for (int j = (end -= start) - 1; j >= i; --j) {
            if (!FluxUtils.isBadPasswordChar(source.charAt(j))) continue;
            filtered.delete(j, j + 1);
        }
        return filtered;
    }
}

