/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.misc;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public enum FluxConfigurationType {
    NETWORK("network_id"),
    PRIORITY("priority"),
    PRIORITY_SETTING("surge_mode"),
    TRANSFER("limit"),
    TRANSFER_SETTING("disable_limit");

    public static final FluxConfigurationType[] VALUES;
    private final String key;

    private FluxConfigurationType(String key) {
        this.key = key;
    }

    public void copy(@Nonnull Player player, @Nonnull CompoundTag tag, @Nonnull TileFluxDevice device) {
        switch (this.ordinal()) {
            case 0: {
                tag.putInt(this.key, device.getNetworkID());
                break;
            }
            case 1: {
                tag.putInt(this.key, device.getRawPriority());
                break;
            }
            case 2: {
                tag.putBoolean(this.key, device.getSurgeMode());
                break;
            }
            case 3: {
                tag.putLong(this.key, device.getRawLimit());
                break;
            }
            case 4: {
                tag.putBoolean(this.key, device.getDisableLimit());
            }
        }
    }

    public void paste(@Nonnull Player player, @Nonnull CompoundTag tag, @Nonnull TileFluxDevice device) {
        if (!tag.contains(this.key)) {
            return;
        }
        if (this == NETWORK) {
            FluxNetwork network;
            if (device.getDeviceType() != FluxDeviceType.CONTROLLER && (!(network = FluxNetworkData.getNetwork(tag.getInt(this.key))).isValid() || network.canPlayerAccess(player))) {
                if (network.isValid()) {
                    device.setOwnerUUID(player.getUUID());
                }
                device.connect(network);
            }
        } else {
            device.readCustomTag(tag, (byte)19);
        }
    }

    static {
        VALUES = FluxConfigurationType.values();
    }
}

