/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import noppes.npcs.shared.client.gui.components.GuiBasic;
import noppes.npcs.shared.common.util.NaturalOrderComparator;

public class GuiStringSlotNop<E extends ListEntry>
extends ObjectSelectionList {
    public HashSet<String> selectedList;
    private boolean multiSelect;
    private GuiBasic parent;

    public GuiStringSlotNop(Collection<String> list, GuiBasic parent, boolean multiSelect) {
        Minecraft minecraft = Minecraft.getInstance();
        int n = parent.width;
        int n2 = parent.height - 96;
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, n, n2, 32, 9 + 3);
        this.selectedList = new HashSet();
        this.parent = parent;
        this.multiSelect = multiSelect;
        if (list != null) {
            this.setList(list);
        }
    }

    public void setList(Collection<String> l) {
        this.clearEntries();
        ArrayList<String> list = new ArrayList<String>(l);
        Collections.sort(list, new NaturalOrderComparator());
        for (String s : list) {
            this.addEntry((AbstractSelectionList.Entry)new ListEntry(s));
        }
        this.setSelected((AbstractSelectionList.Entry)((ListEntry)null));
    }

    public void setColoredList(Map<String, Integer> m) {
        this.clearEntries();
        ArrayList<String> list = new ArrayList<String>(m.keySet());
        Collections.sort(list, new NaturalOrderComparator());
        for (String s : list) {
            this.addEntry((AbstractSelectionList.Entry)new ListEntry(s, m.get(s)));
        }
        this.setSelected((AbstractSelectionList.Entry)((ListEntry)null));
    }

    public void setSelected(String s) {
        if (s == null) {
            this.setSelected((AbstractSelectionList.Entry)((ListEntry)null));
        } else {
            for (Object e : this.children()) {
                if (!((ListEntry)((Object)e)).data.equals(s)) continue;
                this.setSelected((AbstractSelectionList.Entry)((ListEntry)((Object)e)));
            }
        }
    }

    public String getSelectedString() {
        if (this.getSelected() == null) {
            return null;
        }
        return ((ListEntry)this.getSelected()).data;
    }

    protected boolean isSelectedItem(int i) {
        if (!this.multiSelect) {
            return super.isSelectedItem(i);
        }
        return this.selectedList.contains(((ListEntry)this.getEntry((int)i)).data);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.parent.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    public void clear() {
        this.clearEntries();
    }

    public class ListEntry
    extends ObjectSelectionList.Entry {
        public final String data;
        public final int color;
        private long prevTime = 0L;

        public ListEntry(String data) {
            this.data = data;
            this.color = 0xFFFFFF;
        }

        public ListEntry(String data, int color) {
            this.data = data;
            this.color = color;
        }

        public void render(GuiGraphics graphics, int index, int rowTop, int rowBottom, int width, int height, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            graphics.drawString(GuiStringSlotNop.this.parent.getFontRenderer(), this.data, rowBottom, rowTop, this.color);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            long time = System.currentTimeMillis();
            ListEntry s = (ListEntry)GuiStringSlotNop.this.getSelected();
            if (s == this && time - this.prevTime < 400L) {
                GuiStringSlotNop.this.parent.doubleClicked();
            }
            this.prevTime = time;
            GuiStringSlotNop.this.setSelected((AbstractSelectionList.Entry)this);
            if (GuiStringSlotNop.this.selectedList.contains(this.data)) {
                GuiStringSlotNop.this.selectedList.remove(this.data);
            } else {
                GuiStringSlotNop.this.selectedList.add(this.data);
            }
            GuiStringSlotNop.this.parent.elementClicked();
            return true;
        }

        public Component getNarration() {
            return Component.literal((String)this.data);
        }
    }
}

