/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketPlayerMailSend
extends PacketServerBasic {
    private final CompoundTag data;
    private final String username;

    public SPacketPlayerMailSend(String username, CompoundTag data) {
        this.username = username;
        this.data = data;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return true;
    }

    public static void encode(SPacketPlayerMailSend msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.username);
        buf.writeNbt((Tag)msg.data);
    }

    public static SPacketPlayerMailSend decode(FriendlyByteBuf buf) {
        return new SPacketPlayerMailSend(buf.readUtf(Short.MAX_VALUE), buf.readNbt());
    }

    @Override
    protected void handle() {
        String username = PlayerDataController.instance.hasPlayer(this.username);
        if (username.isEmpty()) {
            NoppesUtilServer.sendGuiError((Player)this.player, 0);
            return;
        }
        PlayerMail mail = new PlayerMail();
        Object s = this.player.getDisplayName().getString();
        if (!((String)s).equals(this.player.getName().getString())) {
            s = (String)s + "(" + this.player.getName().getString() + ")";
        }
        mail.readNBT(this.data);
        mail.sender = s;
        if (mail.subject.isEmpty()) {
            NoppesUtilServer.sendGuiError((Player)this.player, 1);
            return;
        }
        mail.items = ((ContainerMail)this.player.containerMenu).mail.items;
        CompoundTag comp = new CompoundTag();
        comp.putString("username", username);
        NoppesUtilServer.sendGuiClose(this.player, 1, comp);
        this.player.closeContainer();
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((Player)this.player);
        if (npc != null && EventHooks.onNPCRole(npc, new RoleEvent.MailmanEvent((Player)this.player, npc.wrappedNPC, mail))) {
            return;
        }
        PlayerDataController.instance.addPlayerMessage(this.player.getServer(), username, mail);
    }
}

