/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.client.gui.GuiAchievement;
import noppes.npcs.shared.common.PacketBasic;

public class PacketAchievement
extends PacketBasic {
    private final Component title;
    private final Component message;
    private final int type;

    public PacketAchievement(Component title, Component message, int type) {
        this.title = title;
        this.message = message;
        this.type = type;
    }

    public static void encode(PacketAchievement msg, FriendlyByteBuf buf) {
        buf.writeJsonWithCodec(ComponentSerialization.CODEC, (Object)msg.title);
        buf.writeJsonWithCodec(ComponentSerialization.CODEC, (Object)msg.message);
        buf.writeInt(msg.type);
    }

    public static PacketAchievement decode(FriendlyByteBuf buf) {
        return new PacketAchievement((Component)buf.readJsonWithCodec(ComponentSerialization.CODEC), (Component)buf.readJsonWithCodec(ComponentSerialization.CODEC), buf.readInt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handle() {
        Minecraft.getInstance().getToasts().addToast((Toast)new GuiAchievement(this.title, this.message, this.type));
    }
}

