/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixinintf.IMixinClientboundAddEntityPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientboundAddEntityPacket.class})
public class MixinClientboundAddEntityPacket
implements IMixinClientboundAddEntityPacket {
    @Unique
    private FriendlyByteBuf buf;
    @Unique
    private Entity entity;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerEntity;)V"}, at={@At(value="TAIL")})
    public void initFromEnt1(Entity entity, ServerEntity serverEntity, CallbackInfo ci) {
        this.entity = entity;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerEntity;I)V"}, at={@At(value="TAIL")})
    public void initFromEnt2(Entity entity, ServerEntity serverEntity, int data, CallbackInfo ci) {
        this.entity = entity;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/Entity;ILnet/minecraft/core/BlockPos;)V"}, at={@At(value="TAIL")})
    public void initFromEnt3(Entity entity, int data, BlockPos pos, CallbackInfo ci) {
        this.entity = entity;
    }

    @Inject(method={"<init>(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V"}, at={@At(value="TAIL")})
    public void initFromBuf(RegistryFriendlyByteBuf buffer, CallbackInfo ci) {
        int count = buffer.readVarInt();
        if (count > 0) {
            FriendlyByteBuf spawnDataBuffer = new FriendlyByteBuf(Unpooled.buffer());
            spawnDataBuffer.writeBytes((ByteBuf)buffer, count);
            this.buf = spawnDataBuffer;
            return;
        }
        this.buf = new FriendlyByteBuf(Unpooled.buffer());
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    public void write(RegistryFriendlyByteBuf buffer, CallbackInfo ci) {
        if (this.entity instanceof EntityNPCInterface) {
            FriendlyByteBuf spawnDataBuffer = new FriendlyByteBuf(Unpooled.buffer());
            ((EntityNPCInterface)this.entity).writeSpawnData(spawnDataBuffer);
            buffer.writeVarInt(spawnDataBuffer.readableBytes());
            buffer.writeBytes((ByteBuf)spawnDataBuffer);
            spawnDataBuffer.release();
        } else {
            buffer.writeVarInt(0);
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public FriendlyByteBuf getBuf() {
        return this.buf;
    }
}

