/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemDataComponents;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.shared.common.CommonUtil;

public class ItemSoulstoneEmpty
extends Item {
    public ItemSoulstoneEmpty() {
        super(new Item.Properties().stacksTo(64));
    }

    public boolean store(LivingEntity entity, ItemStack stack, Player player) {
        if (!this.hasPermission(entity, player) || entity instanceof Player) {
            return false;
        }
        ItemStack stone = new ItemStack((ItemLike)CustomItems.soulstoneFull);
        CustomData data = CustomData.of((CompoundTag)new CompoundTag());
        CompoundTag compound = new CompoundTag();
        if (!entity.saveAsPassenger(compound)) {
            return false;
        }
        ServerCloneController.Instance.cleanTags(compound);
        CompoundTag soulStoneTag = data.getUnsafe();
        soulStoneTag.put("Entity", (Tag)compound);
        String name = entity.getEncodeId();
        if (name == null) {
            name = "generic";
        }
        soulStoneTag.put("Name", (Tag)StringTag.valueOf((String)name));
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            soulStoneTag.put("DisplayName", (Tag)StringTag.valueOf((String)entity.getName().getString()));
            if (npc.role.getType() == 6) {
                RoleCompanion role = (RoleCompanion)npc.role;
                soulStoneTag.put("ExtraText", (Tag)StringTag.valueOf((String)("companion.stage,: ," + role.stage.name)));
            }
        } else if (entity.hasCustomName()) {
            soulStoneTag.put("DisplayName", (Tag)StringTag.valueOf((String)entity.getCustomName().getString()));
        }
        stone.set(ItemDataComponents.SOULSTONE_DATA, (Object)data);
        NoppesUtilServer.GivePlayerItem((Entity)player, player, stone);
        if (!player.getAbilities().instabuild) {
            stack.split(1);
            if (stack.getCount() <= 0) {
                player.getInventory().removeItem(stack);
            }
        }
        entity.discard();
        return true;
    }

    public boolean hasPermission(LivingEntity entity, Player player) {
        if (CommonUtil.isOp(player)) {
            return true;
        }
        if (CustomNpcsPermissions.hasPermission((ServerPlayer)player, CustomNpcsPermissions.SOULSTONE_ALL)) {
            return true;
        }
        if (entity instanceof EntityNPCInterface) {
            RoleInterface role;
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.role.getType() == 6 && ((RoleCompanion)(role = (RoleCompanion)npc.role)).getOwner() == player) {
                return true;
            }
            if (npc.role.getType() == 2 && ((RoleFollower)(role = (RoleFollower)npc.role)).getOwner() == player) {
                return !((RoleFollower)role).refuseSoulStone;
            }
            return CustomNpcs.SoulStoneNPCs;
        }
        if (entity instanceof Animal) {
            return CustomNpcs.SoulStoneAnimals;
        }
        return false;
    }
}

