/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.handler.data.IQuestCategory;
import noppes.npcs.controllers.data.Quest;

public class QuestCategory
implements IQuestCategory {
    public HashMap<Integer, Quest> quests = new HashMap();
    public int id = -1;
    public String title = "";

    public void readNBT(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        this.id = nbttagcompound.getInt("Slot");
        this.title = nbttagcompound.getString("Title");
        ListTag dialogsList = nbttagcompound.getList("Dialogs", 10);
        if (dialogsList != null) {
            for (int ii = 0; ii < dialogsList.size(); ++ii) {
                CompoundTag nbttagcompound2 = dialogsList.getCompound(ii);
                Quest quest = new Quest(this);
                quest.readNBT(lookupProvider, nbttagcompound2);
                this.quests.put(quest.id, quest);
            }
        }
    }

    public CompoundTag writeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        nbttagcompound.putInt("Slot", this.id);
        nbttagcompound.putString("Title", this.title);
        ListTag dialogs = new ListTag();
        for (int dialogId : this.quests.keySet()) {
            Quest quest = this.quests.get(dialogId);
            dialogs.add((Object)quest.save(lookupProvider, new CompoundTag()));
        }
        nbttagcompound.put("Dialogs", (Tag)dialogs);
        return nbttagcompound;
    }

    @Override
    public List<IQuest> quests() {
        return new ArrayList<IQuest>(this.quests.values());
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public IQuest create() {
        return new Quest(this);
    }
}

