/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.Bank;

public class BankController {
    public HashMap<Integer, Bank> banks;
    private String filePath = "";
    private static BankController instance;

    public BankController(HolderLookup.Provider lookupProvider) {
        instance = this;
        this.banks = new HashMap();
        this.loadBanks(lookupProvider);
        if (this.banks.isEmpty()) {
            Bank bank = new Bank();
            bank.id = 0;
            bank.name = "Default Bank";
            for (int i = 0; i < 6; ++i) {
                bank.slotTypes.put(i, 0);
            }
            this.banks.put(bank.id, bank);
        }
    }

    public static BankController getInstance(HolderLookup.Provider lookupProvider) {
        if (BankController.newInstance()) {
            instance = new BankController(lookupProvider);
        }
        return instance;
    }

    private static boolean newInstance() {
        if (instance == null) {
            return true;
        }
        File file = CustomNpcs.getLevelSaveDirectory();
        if (file == null) {
            return false;
        }
        return !BankController.instance.filePath.equals(file.getAbsolutePath());
    }

    private void loadBanks(HolderLookup.Provider lookupProvider) {
        File saveDir = CustomNpcs.getLevelSaveDirectory();
        if (saveDir == null) {
            return;
        }
        this.filePath = saveDir.getAbsolutePath();
        try {
            File file = new File(saveDir, "bank.dat");
            if (file.exists()) {
                this.loadBanks(lookupProvider, file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(saveDir, "bank.dat_old");
                if (file.exists()) {
                    this.loadBanks(lookupProvider, file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadBanks(HolderLookup.Provider lookupProvider, File file) throws IOException {
        this.loadBanks(lookupProvider, NbtIo.readCompressed((InputStream)new FileInputStream(file), (NbtAccounter)NbtAccounter.unlimitedHeap()));
    }

    public void loadBanks(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound1) throws IOException {
        HashMap<Integer, Bank> banks = new HashMap<Integer, Bank>();
        ListTag list = nbttagcompound1.getList("Data", 10);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbttagcompound = list.getCompound(i);
                Bank bank = new Bank();
                bank.readAdditionalSaveData(lookupProvider, nbttagcompound);
                banks.put(bank.id, bank);
            }
        }
        this.banks = banks;
    }

    public CompoundTag getNBT(HolderLookup.Provider lookupProvider) {
        ListTag list = new ListTag();
        for (Bank bank : this.banks.values()) {
            CompoundTag nbtfactions = new CompoundTag();
            bank.addAdditionalSaveData(lookupProvider, nbtfactions);
            list.add((Object)nbtfactions);
        }
        CompoundTag nbttagcompound = new CompoundTag();
        nbttagcompound.put("Data", (Tag)list);
        return nbttagcompound;
    }

    public Bank getBank(int bankId) {
        Bank bank = this.banks.get(bankId);
        if (bank != null) {
            return bank;
        }
        return this.banks.values().iterator().next();
    }

    public void saveBanks(HolderLookup.Provider lookupProvider) {
        try {
            File saveDir = CustomNpcs.getLevelSaveDirectory();
            File file = new File(saveDir, "bank.dat_new");
            File file1 = new File(saveDir, "bank.dat_old");
            File file2 = new File(saveDir, "bank.dat");
            NbtIo.writeCompressed((CompoundTag)this.getNBT(lookupProvider), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveBank(HolderLookup.Provider lookupProvider, Bank bank) {
        if (bank.id < 0) {
            bank.id = this.getUnusedId();
        }
        this.banks.put(bank.id, bank);
        this.saveBanks(lookupProvider);
    }

    public int getUnusedId() {
        int id = 0;
        while (this.banks.containsKey(id)) {
            ++id;
        }
        return id;
    }

    public void removeBank(HolderLookup.Provider lookupProvider, int bank) {
        if (bank < 0 || this.banks.size() <= 1) {
            return;
        }
        this.banks.remove(bank);
        this.saveBanks(lookupProvider);
    }
}

