/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import noppes.npcs.controllers.data.MarkData;

public class CmdMark {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"mark").requires(source -> source.hasPermission(2));
        command.then(Commands.argument((String)"clear", (ArgumentType)EntityArgument.entities()).executes(context -> {
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"entities");
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                MarkData data = MarkData.get((LivingEntity)entity);
                data.marks.clear();
                data.syncClients();
            }
            return 1;
        }));
        command.then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"entities");
            if (entities.isEmpty()) {
                return 1;
            }
            int type = IntegerArgumentType.getInteger((CommandContext)context, (String)"type");
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                MarkData data = MarkData.get((LivingEntity)entity);
                data.marks.clear();
                data.addMark(type, 0xFFFFFF);
            }
            return 1;
        })).then((ArgumentBuilder)Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()))).executes(context -> {
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"entities");
            if (entities.isEmpty()) {
                return 1;
            }
            int type = IntegerArgumentType.getInteger((CommandContext)context, (String)"type");
            int color = 0xFFFFFF;
            try {
                color = Integer.parseInt(StringArgumentType.getString((CommandContext)context, (String)"color"), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                MarkData data = MarkData.get((LivingEntity)entity);
                data.marks.clear();
                data.addMark(type, color);
            }
            return 1;
        })));
        return command;
    }
}

