/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcMenu;
import noppes.npcs.entity.EntityNPCInterface;

public abstract class GuiContainerNPCInterface2<T extends AbstractContainerMenu>
extends GuiContainerNPCInterface<T> {
    private ResourceLocation background = new ResourceLocation("customnpcs", "textures/gui/menubg.png");
    private final ResourceLocation defaultBackground = new ResourceLocation("customnpcs", "textures/gui/menubg.png");
    private GuiNpcMenu menu;
    public int menuYOffset = 0;

    public GuiContainerNPCInterface2(EntityNPCInterface npc, T cont, Inventory inv, Component titleIn) {
        this(npc, cont, inv, titleIn, -1);
    }

    public GuiContainerNPCInterface2(EntityNPCInterface npc, T cont, Inventory inv, Component titleIn, int activeMenu) {
        super(npc, cont, inv, titleIn);
        this.imageWidth = 420;
        this.menu = new GuiNpcMenu(this, activeMenu, npc);
        this.title = "";
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    @Override
    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    @Override
    public void init() {
        super.init();
        this.menu.initGui(this.guiLeft, this.guiTop + this.menuYOffset, this.imageWidth);
    }

    @Override
    public boolean mouseClicked(double i, double j, int k) {
        if (!this.hasSubGui()) {
            this.menu.mouseClicked(i, j, k);
        }
        return super.mouseClicked(i, j, k);
    }

    public void delete() {
        this.npc.delete();
        this.setScreen(null);
        this.minecraft.mouseHandler.grabMouse();
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        PoseStack matrixStack = graphics.pose();
        this.renderBackground(graphics, this.mouseX, this.mouseY, partialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.background);
        graphics.blit(this.background, this.guiLeft, this.guiTop, 0, 0, 256, 256);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.defaultBackground);
        graphics.blit(this.defaultBackground, this.guiLeft + this.imageWidth - 200, this.guiTop, 26, 0, 200, 220);
        this.menu.drawElements(graphics, this.font, x, y, this.minecraft, partialTicks);
        super.renderBg(graphics, partialTicks, x, y);
    }
}

