/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityDisplayWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.entity.EntityNPCInterface;
import org.joml.Matrix4fStack;

public class CustomGuiEntityDisplay
extends AbstractWidget
implements IGuiComponent {
    private GuiCustom parent;
    public CustomGuiEntityDisplayWrapper component;
    private Entity entity;
    public int id;

    public CustomGuiEntityDisplay(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (Component)Component.empty());
        this.component = component;
        this.parent = parent;
        this.init();
    }

    @Override
    public void init() {
        this.id = this.component.getID();
        this.setX(this.component.getPosX());
        this.setY(this.component.getPosY());
        this.setWidth(this.component.getWidth());
        this.height = this.component.getHeight();
        if (this.component.entityId != -1) {
            this.entity = Minecraft.getInstance().player.getCommandSenderWorld().getEntity(this.component.entityId);
        } else if (!this.component.getEntityData().isEmpty()) {
            this.entity = EntityType.create((CompoundTag)this.component.getEntityData().getMCNBT(), (Level)Minecraft.getInstance().level).orElse(null);
        }
        this.active = this.component.getEnabled() && this.component.getVisible();
        this.visible = this.component.getVisible();
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean hovered;
        if (!this.visible) {
            return;
        }
        if (this.component.getBackground()) {
            graphics.fillGradient(this.getX(), this.getY(), this.width + this.getX(), this.height + this.getY(), -1072689136, -804253680);
        }
        if (this.entity != null) {
            CustomGuiEntityDisplay.drawEntity(graphics, this.entity, this.getX(), this.getY(), this.component.getScale(), this.component.getRotation() / 2 + 180, mouseX, mouseY, (float)this.width / 2.0f, (float)this.height * 0.9f, this.component.isFollowingCursor);
        }
        boolean bl = hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        if (hovered && this.component.hasHoverText()) {
            this.parent.hoverText = this.component.getHoverTextList();
        }
    }

    protected void renderWidget(GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        return true;
    }

    public static CustomGuiEntityDisplay fromComponent(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        CustomGuiEntityDisplay btn = new CustomGuiEntityDisplay(parent, component);
        return btn;
    }

    public static void drawEntity(GuiGraphics graphics, Entity entity, int x, int y, float zoomed, int rotation, int xMouse, int yMouse, float guiLeft, float guiTop) {
        CustomGuiEntityDisplay.drawEntity(graphics, entity, x, y, zoomed, rotation, xMouse, yMouse, guiLeft, guiTop, true);
    }

    public static void drawEntity(GuiGraphics graphics, Entity entity, int x, int y, float zoomed, int rotation, int xMouse, int yMouse, float guiLeft, float guiTop, boolean followCursor) {
        EntityNPCInterface npc = null;
        if (entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)entity;
        }
        LivingEntity livingEntity = null;
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
        }
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f2 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (livingEntity != null) {
            f2 = livingEntity.yBodyRot;
            f5 = livingEntity.yHeadRotO;
            f6 = livingEntity.yHeadRot;
        }
        float scale = 1.0f;
        if ((double)entity.getBbHeight() > 2.4) {
            scale = 2.0f / entity.getBbHeight();
        }
        float f7 = guiLeft + (float)x - (float)xMouse;
        float f8 = (guiTop + (float)y - 50.0f * scale * zoomed) * (entity.getBbHeight() / entity.getEyeHeight()) - (float)yMouse;
        if (followCursor) {
            entity.setYRot((float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation);
            entity.setXRot(-((float)Math.atan(f8 / 40.0f)) * 20.0f);
        } else {
            entity.setYRot((float)rotation);
            entity.setXRot(0.0f);
        }
        if (livingEntity != null) {
            livingEntity.yHeadRot = livingEntity.yBodyRot = entity.getYRot();
            livingEntity.yHeadRotO = livingEntity.yBodyRot;
        }
        int orientation = 0;
        int showname = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = (int)entity.getYRot();
            showname = npc.display.getShowName();
            npc.display.setShowName(1);
        }
        float fs = 30.0f * scale * zoomed;
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.translate(0.0f, 0.0f, 1050.0f);
        posestack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack = new PoseStack();
        matrixStack.translate(guiLeft + (float)x, guiTop + (float)y, 0.0f);
        matrixStack.scale(fs, fs, fs);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YN.rotationDegrees((float)rotation));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityrenderdispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)graphics.bufferSource(), 0xF000F0));
        graphics.flush();
        entityrenderdispatcher.setRenderShadow(true);
        posestack.scale(1.0f, 1.0f, -1.0f);
        posestack.translate(0.0f, 0.0f, -1050.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        matrixStack.popPose();
        entity.setYRot(f3);
        entity.setXRot(f4);
        if (livingEntity != null) {
            livingEntity.yBodyRot = f2;
            livingEntity.yHeadRotO = f5;
            livingEntity.yHeadRot = f6;
        }
        if (npc != null) {
            npc.ais.orientation = orientation;
            npc.display.setShowName(showname);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }
}

