/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.controllers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class MusicController {
    public static MusicController Instance;
    public SoundInstance playing;
    public ResourceLocation playingResource;
    public Entity playingEntity;

    public MusicController() {
        Instance = this;
    }

    public void stopMusic() {
        SoundManager handler = Minecraft.getInstance().getSoundManager();
        if (this.playing != null) {
            handler.stop(this.playing);
        }
        handler.stop(null, SoundSource.MUSIC);
        handler.stop(null, SoundSource.AMBIENT);
        handler.stop(null, SoundSource.RECORDS);
        this.playingResource = null;
        this.playingEntity = null;
        this.playing = null;
    }

    public void playStreaming(String music, Entity entity, boolean isLooping) {
        if (this.isPlaying(music)) {
            return;
        }
        this.stopMusic();
        this.playingEntity = entity;
        this.playingResource = ResourceLocation.tryParse((String)music);
        SoundManager handler = Minecraft.getInstance().getSoundManager();
        this.playing = new SimpleSoundInstance(this.playingResource, SoundSource.RECORDS, 4.0f, 1.0f, SoundInstance.createUnseededRandom(), isLooping, 0, SoundInstance.Attenuation.LINEAR, entity.getX(), entity.getY(), entity.getZ(), false);
        handler.play(this.playing);
    }

    public void playMusic(String music, Entity entity, boolean isLooping) {
        if (this.isPlaying(music)) {
            return;
        }
        this.stopMusic();
        this.playingResource = ResourceLocation.tryParse((String)music);
        this.playingEntity = entity;
        SoundManager handler = Minecraft.getInstance().getSoundManager();
        this.playing = new SimpleSoundInstance(this.playingResource, SoundSource.MUSIC, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), isLooping, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, false);
        handler.play(this.playing);
    }

    public boolean isPlaying(String music) {
        ResourceLocation resource = ResourceLocation.tryParse((String)music);
        if (this.playingResource == null || !this.playingResource.equals((Object)resource)) {
            return false;
        }
        return Minecraft.getInstance().getSoundManager().isActive(this.playing);
    }

    public void playSound(SoundSource cat, String music, BlockPos pos, float volume, float pitch) {
        SimpleSoundInstance rec = new SimpleSoundInstance(ResourceLocation.tryParse((String)music), cat, volume, pitch, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.LINEAR, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), false);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)rec);
    }
}

