/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileBlockAnvil;
import noppes.npcs.constants.EnumGuiType;

public class BlockCarpentryBench
extends BlockInterface {
    public static final MapCodec<BlockCarpentryBench> CODEC = BlockCarpentryBench.simpleCodec(BlockCarpentryBench::new);
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);

    public BlockCarpentryBench() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).sound(SoundType.WOOD).strength(5.0f, 10.0f));
    }

    public BlockCarpentryBench(BlockBehaviour.Properties p_49696_) {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).sound(SoundType.WOOD).strength(5.0f, 10.0f));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            NoppesUtilServer.openContainerGui((ServerPlayer)player, EnumGuiType.PlayerAnvil, buffer -> buffer.writeBlockPos(pos));
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getOcclusionShape(BlockState p_196247_1_, BlockGetter p_196247_2_, BlockPos p_196247_3_) {
        return Shapes.empty();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int var6 = Mth.floor((double)((double)(context.getPlayer().getYRot() / 90.0f) + 0.5)) & 3;
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(var6));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileBlockAnvil(pos, state);
    }
}

