/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.controllers.data.MarkData;

public class EntityLivingBaseWrapper<T extends LivingEntity>
extends EntityWrapper<T>
implements IEntityLiving {
    public EntityLivingBaseWrapper(T entity) {
        super(entity);
    }

    @Override
    public float getHealth() {
        return ((LivingEntity)this.entity).getHealth();
    }

    @Override
    public void setHealth(float health) {
        ((LivingEntity)this.entity).setHealth(health);
    }

    @Override
    public float getMaxHealth() {
        return ((LivingEntity)this.entity).getMaxHealth();
    }

    @Override
    public void setMaxHealth(float health) {
        if (health < 0.0f) {
            return;
        }
        ((LivingEntity)this.entity).getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)health);
    }

    @Override
    public boolean isAttacking() {
        return ((LivingEntity)this.entity).getLastHurtByMob() != null;
    }

    @Override
    public void setAttackTarget(IEntityLiving living) {
        if (living == null) {
            ((LivingEntity)this.entity).setLastHurtByMob(null);
        } else {
            ((LivingEntity)this.entity).setLastHurtByMob(living.getMCEntity());
        }
    }

    @Override
    public IEntityLiving getAttackTarget() {
        return (IEntityLiving)NpcAPI.Instance().getIEntity((Entity)((LivingEntity)this.entity).getLastHurtByMob());
    }

    @Override
    public IEntityLiving getLastAttacked() {
        return (IEntityLiving)NpcAPI.Instance().getIEntity((Entity)((LivingEntity)this.entity).getLastHurtMob());
    }

    @Override
    public int getLastAttackedTime() {
        return ((LivingEntity)this.entity).getLastHurtMobTimestamp();
    }

    @Override
    public boolean canSeeEntity(IEntity entity) {
        return ((LivingEntity)this.entity).hasLineOfSight(entity.getMCEntity());
    }

    @Override
    public void swingMainhand() {
        ((LivingEntity)this.entity).swing(InteractionHand.MAIN_HAND);
    }

    @Override
    public void swingOffhand() {
        ((LivingEntity)this.entity).swing(InteractionHand.OFF_HAND);
    }

    @Override
    public void addPotionEffect(int effect, int duration, int strength, boolean hideParticles) {
        MobEffect p = (MobEffect)BuiltInRegistries.MOB_EFFECT.byId(effect);
        if (p == null) {
            return;
        }
        if (strength < 0) {
            strength = 0;
        } else if (strength > 255) {
            strength = 255;
        }
        if (duration < 0) {
            duration = 0;
        } else if (duration > 1000000) {
            duration = 1000000;
        }
        if (!p.isInstantenous()) {
            duration *= 20;
        }
        if (duration == 0) {
            ((LivingEntity)this.entity).removeEffect((Holder)PotionEffectType.getHolder(effect).get());
        } else {
            ((LivingEntity)this.entity).addEffect(new MobEffectInstance((Holder)PotionEffectType.getHolder(effect).get(), duration, strength, false, hideParticles));
        }
    }

    @Override
    public void clearPotionEffects() {
        ((LivingEntity)this.entity).removeAllEffects();
    }

    @Override
    public int getPotionEffect(int effect) {
        MobEffectInstance pf = ((LivingEntity)this.entity).getEffect(Holder.direct((Object)((MobEffect)BuiltInRegistries.MOB_EFFECT.byId(effect))));
        if (pf == null) {
            return -1;
        }
        return pf.getAmplifier();
    }

    @Override
    public IItemStack getMainhandItem() {
        return NpcAPI.Instance().getIItemStack(((LivingEntity)this.entity).getMainHandItem());
    }

    @Override
    public void setMainhandItem(IItemStack item) {
        ((LivingEntity)this.entity).setItemInHand(InteractionHand.MAIN_HAND, item == null ? ItemStack.EMPTY : item.getMCItemStack());
    }

    @Override
    public IItemStack getOffhandItem() {
        return NpcAPI.Instance().getIItemStack(((LivingEntity)this.entity).getOffhandItem());
    }

    @Override
    public void setOffhandItem(IItemStack item) {
        ((LivingEntity)this.entity).setItemInHand(InteractionHand.OFF_HAND, item == null ? ItemStack.EMPTY : item.getMCItemStack());
    }

    @Override
    public IItemStack getArmor(int slot) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(((LivingEntity)this.entity).getItemBySlot(this.getSlot(slot)));
    }

    @Override
    public void setArmor(int slot, IItemStack item) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        ((LivingEntity)this.entity).setItemSlot(this.getSlot(slot), item == null ? ItemStack.EMPTY : item.getMCItemStack());
    }

    private EquipmentSlot getSlot(int slot) {
        if (slot == 3) {
            return EquipmentSlot.HEAD;
        }
        if (slot == 2) {
            return EquipmentSlot.CHEST;
        }
        if (slot == 1) {
            return EquipmentSlot.LEGS;
        }
        if (slot == 0) {
            return EquipmentSlot.FEET;
        }
        return null;
    }

    @Override
    public float getRotation() {
        return ((LivingEntity)this.entity).yBodyRot;
    }

    @Override
    public void setRotation(float rotation) {
        ((LivingEntity)this.entity).yBodyRot = rotation;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 5 ? true : super.typeOf(type);
    }

    @Override
    public boolean isChild() {
        return ((LivingEntity)this.entity).isBaby();
    }

    @Override
    public IMark addMark(int type) {
        MarkData data = MarkData.get((LivingEntity)this.entity);
        return data.addMark(type);
    }

    @Override
    public void removeMark(IMark mark) {
        MarkData data = MarkData.get((LivingEntity)this.entity);
        data.marks.remove(mark);
        data.syncClients();
    }

    @Override
    public IMark[] getMarks() {
        MarkData data = MarkData.get((LivingEntity)this.entity);
        return data.marks.toArray(new IMark[data.marks.size()]);
    }

    @Override
    public float getMoveForward() {
        return ((LivingEntity)this.entity).zza;
    }

    @Override
    public void setMoveForward(float move) {
        ((LivingEntity)this.entity).zza = move;
    }

    @Override
    public float getMoveStrafing() {
        return ((LivingEntity)this.entity).xxa;
    }

    @Override
    public void setMoveStrafing(float move) {
        ((LivingEntity)this.entity).xxa = move;
    }

    @Override
    public float getMoveVertical() {
        return ((LivingEntity)this.entity).yya;
    }

    @Override
    public void setMoveVertical(float move) {
        ((LivingEntity)this.entity).yya = move;
    }
}

