/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import nikedemos.markovnames.generators.MarkovGenerator;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomTabs;
import noppes.npcs.ScriptItemEventHandler;
import noppes.npcs.ScriptPlayerEventHandler;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.command.CmdNoppes;
import noppes.npcs.command.CmdSchematics;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.common.util.LogWriter;

@Mod(value="customnpcs")
public class CustomNpcs {
    public static final String MODID = "customnpcs";
    public static final String VERSION = "1.20.2";
    @ConfigProp(info="Whether scripting is enabled or not")
    public static boolean EnableScripting = true;
    @ConfigProp(info="Arguments given to the Nashorn scripting library")
    public static String NashorArguments = "-strict";
    @ConfigProp(info="Disable Chat Bubbles")
    public static boolean EnableChatBubbles = true;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Limit too how many npcs can be in one chunk for natural spawning")
    public static int NpcNaturalSpawningChunkLimit = 4;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp(info="If set to true only opped people can use the /noppes command")
    public static boolean NoppesCommandOpOnly = false;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    public static boolean FixUpdateFromPre_1_12 = false;
    public static boolean DisablePermissions = false;
    @ConfigProp
    public static boolean SceneButtonsEnabled = true;
    public static long ticks;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    public static boolean OpsOnly;
    @ConfigProp(info="Default interact line. Leave empty to not have one")
    public static String DefaultInteractLine;
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time")
    public static int ChuckLoaders;
    public static File Dir;
    @ConfigProp(info="Enables leaves decay")
    public static boolean LeavesDecayEnabled;
    @ConfigProp(info="Enables Vine Growth")
    public static boolean VineGrowthEnabled;
    @ConfigProp(info="Enables Ice Melting")
    public static boolean IceMeltsEnabled;
    @ConfigProp(info="Normal players can use soulstone on animals")
    public static boolean SoulStoneAnimals;
    @ConfigProp(info="Normal players can use soulstone on all npcs")
    public static boolean SoulStoneNPCs;
    @ConfigProp(info="Cloner saves NPC Path")
    public static boolean ClonerSavePath;
    @ConfigProp(info="Type 0 = Normal, Type 1 = Solid")
    public static int HeadWearType;
    @ConfigProp(info="When set to Minecraft it will use minecrafts font, when Default it will use OpenSans. Can only use fonts installed on your PC")
    public static String FontType;
    @ConfigProp(info="Font size for custom fonts (doesn't work with minecrafts font)")
    public static int FontSize;
    @ConfigProp(info="On some servers or with certain plugins, it doesnt work, so you can disable it here")
    public static boolean EnableInvisibleNpcs;
    @ConfigProp
    public static boolean NpcSpeachTriggersChatEvent;
    public static ConfigLoader Config;
    public static boolean VerboseDebug;
    public static MinecraftServer Server;
    public static CommonProxy proxy;

    public static <T> T runForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return CustomNpcs.unsafeRunForDist(clientTarget, serverTarget);
    }

    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                return clientTarget.get().get();
            }
            case DEDICATED_SERVER: {
                return serverTarget.get().get();
            }
        }
        throw new IllegalArgumentException("UNSIDED?");
    }

    public CustomNpcs(IEventBus modEventBus, ModContainer modContainer) {
        instance = this;
        modEventBus.addListener(this::postLoad);
        modEventBus.addListener(this::setup);
        CustomTabs.CREATIVE_TABS.register(modEventBus);
        File dir = new File(FMLPaths.CONFIGDIR.get().toFile(), "..");
        Config = new ConfigLoader(this.getClass(), new File(dir, "config"), "CustomNpcs");
        Config.loadConfig();
    }

    private void postLoad(FMLLoadCompleteEvent event) {
        proxy.postload();
        CustomItems.registerDispenser();
    }

    private void setup(FMLCommonSetupEvent event) {
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        NeoForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        NeoForge.EVENT_BUS.register((Object)new ServerTickHandler());
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new CustomNpcsPermissions());
        proxy.load();
        PixelmonHelper.load();
        ScriptController controller = new ScriptController();
        if (EnableScripting && controller.languages.size() > 0) {
            NeoForge.EVENT_BUS.register((Object)controller);
            NeoForge.EVENT_BUS.register((Object)new ScriptPlayerEventHandler().registerForgeEvents());
            NeoForge.EVENT_BUS.register((Object)new ScriptItemEventHandler());
        }
        CustomNpcs.setPrivateValue(RangedAttribute.class, (RangedAttribute)Attributes.MAX_HEALTH.value(), Double.MAX_VALUE, 1);
        new RecipeController();
    }

    @SubscribeEvent
    public void setAboutToStart(ServerAboutToStartEvent event) {
        Availability.scores.clear();
        Server = event.getServer();
        MarkovGenerator.load();
        ChunkController.instance.clear();
        FactionController.instance.load();
        new PlayerDataController();
        new TransportController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        new MassBlockController();
        VisibilityController.instance = new VisibilityController();
        ScriptController.Instance.loadCategories();
        ScriptController.Instance.loadStoredData();
        ScriptController.Instance.loadPlayerScripts();
        ScriptController.Instance.loadForgeScripts();
        ScriptController.HasStart = false;
        WrapperNpcAPI.clearCache();
        CmdSchematics.names.clear();
        CmdSchematics.names.addAll(SchematicController.Instance.list());
    }

    @SubscribeEvent
    public void started(ServerStartedEvent event) {
        RecipeController.instance.load((HolderLookup.Provider)event.getServer().registryAccess());
        new BankController((HolderLookup.Provider)event.getServer().registryAccess());
        DialogController.instance.load((HolderLookup.Provider)event.getServer().registryAccess());
        QuestController.instance.load((HolderLookup.Provider)event.getServer().registryAccess());
        ScriptController.HasStart = true;
        ServerCloneController.Instance = new ServerCloneController();
    }

    @SubscribeEvent
    public void stopped(ServerStoppedEvent event) {
        ServerCloneController.Instance = null;
        Server = null;
    }

    @SubscribeEvent
    public void serverstart(ServerStartingEvent event) {
        EntityNPCInterface.ChatEventPlayer = new FakePlayer(event.getServer().getLevel(Level.OVERWORLD), (GameProfile)EntityNPCInterface.ChatEventProfile);
        EntityNPCInterface.CommandPlayer = new FakePlayer(event.getServer().getLevel(Level.OVERWORLD), (GameProfile)EntityNPCInterface.CommandProfile);
        EntityNPCInterface.GenericPlayer = new FakePlayer(event.getServer().getLevel(Level.OVERWORLD), (GameProfile)EntityNPCInterface.GenericProfile);
        for (ServerLevel level : Server.getAllLevels()) {
            ServerScoreboard board = level.getScoreboard();
            board.addDirtyListener(() -> {
                for (String objective : Availability.scores) {
                    Objective so = board.getObjective(objective);
                    if (so == null) continue;
                    for (ServerPlayer player : Server.getPlayerList().getPlayers()) {
                        if (board.getPlayerScoreInfo((ScoreHolder)player, so) == null && board.getObjectiveDisplaySlotCount(so) == 0) {
                            player.connection.send((Packet)new ClientboundSetObjectivePacket(so, 0));
                        }
                        ScoreAccess sco = board.getOrCreatePlayerScore((ScoreHolder)player, so);
                        ReadOnlyScoreInfo info = board.getPlayerScoreInfo((ScoreHolder)player, so);
                        player.connection.send((Packet)new ClientboundSetScorePacket(player.getScoreboardName(), so.getName(), sco.get(), Optional.of(sco.display()), Optional.of(info.numberFormat())));
                    }
                }
            });
            board.addDirtyListener(() -> {
                List players = Server.getPlayerList().getPlayers();
                for (ServerPlayer playerMP : players) {
                    VisibilityController.instance.onUpdate(playerMP);
                }
            });
        }
    }

    @SubscribeEvent
    public void registerCommand(RegisterCommandsEvent e) {
        CmdNoppes.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public static File getLevelSaveDirectory() {
        return CustomNpcs.getLevelSaveDirectory(null);
    }

    public static File getLevelSaveDirectory(String s) {
        try {
            File dir = new File(".");
            if (Server != null) {
                if (!Server.isDedicatedServer()) {
                    dir = new File(Minecraft.getInstance().gameDirectory, "saves");
                }
                dir = Server.getWorldPath(new LevelResource(MODID)).toFile();
            }
            if (s != null) {
                dir = new File(dir, s);
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
        catch (Exception e) {
            LogWriter.error("Error getting worldsave", e);
            return null;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (IllegalAccessException e) {
            LogWriter.error("setPrivateValue error", e);
        }
    }

    static {
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = true;
        DefaultInteractLine = "Hello @p";
        ChuckLoaders = 20;
        LeavesDecayEnabled = true;
        VineGrowthEnabled = true;
        IceMeltsEnabled = true;
        SoulStoneAnimals = true;
        SoulStoneNPCs = false;
        ClonerSavePath = false;
        HeadWearType = 1;
        FontType = "Default";
        FontSize = 18;
        EnableInvisibleNpcs = true;
        NpcSpeachTriggersChatEvent = false;
        VerboseDebug = false;
        proxy = (CommonProxy)CustomNpcs.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        File dir = new File(Paths.get("config", new String[0]).toFile(), "..");
        Dir = new File(dir, MODID);
        if (!Dir.exists()) {
            Dir.mkdir();
        }
    }
}

