/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.mojang.datafixers.DSL;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;
import noppes.npcs.blocks.BlockBorder;
import noppes.npcs.blocks.BlockBuilder;
import noppes.npcs.blocks.BlockCarpentryBench;
import noppes.npcs.blocks.BlockCopy;
import noppes.npcs.blocks.BlockMailbox;
import noppes.npcs.blocks.BlockNpcRedstone;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.blocks.BlockWaypoint;
import noppes.npcs.blocks.tiles.TileBlockAnvil;
import noppes.npcs.blocks.tiles.TileBorder;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.blocks.tiles.TileCopy;
import noppes.npcs.blocks.tiles.TileMailbox;
import noppes.npcs.blocks.tiles.TileRedstoneBlock;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.blocks.tiles.TileWaypoint;
import noppes.npcs.items.ItemNpcBlock;
import noppes.npcs.items.ItemScriptedDoor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="customnpcs")
public class CustomBlocks {
    public static Block redstone;
    public static Item redstone_item;
    public static Block mailbox;
    public static Item mailbox_item;
    public static Block mailbox2;
    public static Item mailbox2_item;
    public static Block mailbox3;
    public static Item mailbox3_item;
    public static Block waypoint;
    public static Item waypoint_item;
    public static Block border;
    public static Item border_item;
    public static Block scripted;
    public static Item scripted_item;
    public static Block scripted_door;
    public static Item scripted_door_item;
    public static Block builder;
    public static Item builder_item;
    public static Block copy;
    public static Item copy_item;
    public static Block carpenty;
    public static Item carpentry_item;
    public static BlockEntityType<TileBlockAnvil> tile_anvil;
    public static BlockEntityType<TileBorder> tile_border;
    public static BlockEntityType<TileBuilder> tile_builder;
    public static BlockEntityType<TileCopy> tile_copy;
    public static BlockEntityType<TileMailbox> tile_mailbox;
    public static BlockEntityType<TileRedstoneBlock> tile_redstoneblock;
    public static BlockEntityType<TileScripted> tile_scripted;
    public static BlockEntityType<TileScriptedDoor> tile_scripteddoor;
    public static BlockEntityType<TileWaypoint> tile_waypoint;

    @SubscribeEvent
    public static void registerBlocks(RegisterEvent event) {
        if (event.getRegistry() == BuiltInRegistries.BLOCK) {
            redstone = new BlockNpcRedstone();
            redstone_item = CustomBlocks.createItem(redstone);
            mailbox = new BlockMailbox(0);
            mailbox_item = CustomBlocks.createItem(mailbox);
            mailbox2 = new BlockMailbox(1);
            mailbox2_item = CustomBlocks.createItem(mailbox2);
            mailbox3 = new BlockMailbox(2);
            mailbox3_item = CustomBlocks.createItem(mailbox3);
            waypoint = new BlockWaypoint();
            waypoint_item = CustomBlocks.createItem(waypoint);
            border = new BlockBorder();
            border_item = CustomBlocks.createItem(border);
            scripted = new BlockScripted();
            scripted_item = CustomBlocks.createItem(scripted);
            scripted_door = new BlockScriptedDoor();
            scripted_door_item = new ItemScriptedDoor(scripted_door);
            builder = new BlockBuilder();
            builder_item = CustomBlocks.createItem(builder);
            copy = new BlockCopy();
            copy_item = CustomBlocks.createItem(copy);
            carpenty = new BlockCarpentryBench();
            carpentry_item = CustomBlocks.createItem(carpenty);
        }
        if (event.getRegistry() == BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            tile_anvil = CustomBlocks.createTile("tileblockanvil", TileBlockAnvil::new, carpenty);
            tile_border = CustomBlocks.createTile("tilenpcborder", TileBorder::new, border);
            tile_builder = CustomBlocks.createTile("tilenpcbuilder", TileBuilder::new, builder);
            tile_copy = CustomBlocks.createTile("tilenpccopy", TileCopy::new, copy);
            tile_mailbox = CustomBlocks.createTile("tilemailbox", TileMailbox::new, mailbox, mailbox2, mailbox3);
            tile_redstoneblock = CustomBlocks.createTile("tileredstoneblock", TileRedstoneBlock::new, redstone);
            tile_scripted = CustomBlocks.createTile("tilenpcscripted", TileScripted::new, scripted);
            tile_scripteddoor = CustomBlocks.createTile("tilenpcscripteddoor", TileScriptedDoor::new, scripted_door);
            tile_waypoint = CustomBlocks.createTile("tilewaypoint", TileWaypoint::new, waypoint);
        }
        if (event.getRegistry() == BuiltInRegistries.BLOCK) {
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcredstoneblock", (Object)redstone);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcmailbox", (Object)mailbox);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcmailbox2", (Object)mailbox2);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcmailbox3", (Object)mailbox3);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcwaypoint", (Object)waypoint);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcborder", (Object)border);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcscripted", (Object)scripted);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcscripteddoor", (Object)scripted_door);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npcbuilderblock", (Object)builder);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npccopyblock", (Object)copy);
            Registry.register((Registry)BuiltInRegistries.BLOCK, (String)"customnpcs:npccarpentybench", (Object)carpenty);
        }
        if (event.getRegistry() == BuiltInRegistries.ITEM) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcredstoneblock", (Object)redstone_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcmailbox", (Object)mailbox_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcmailbox2", (Object)mailbox2_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcmailbox3", (Object)mailbox3_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcwaypoint", (Object)waypoint_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcborder", (Object)border_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcscripted", (Object)scripted_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcscripteddoortool", (Object)scripted_door_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npcbuilderblock", (Object)builder_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npccopyblock", (Object)copy_item);
            Registry.register((Registry)BuiltInRegistries.ITEM, (String)"customnpcs:npccarpentybench", (Object)carpentry_item);
        }
        if (event.getRegistry() == BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tileblockanvil", tile_anvil);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilenpcborder", tile_border);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilenpcbuilder", tile_builder);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilenpccopy", tile_copy);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilemailbox", tile_mailbox);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tileredstoneblock", tile_redstoneblock);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilenpcscripted", tile_scripted);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilenpcscripteddoor", tile_scripteddoor);
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"customnpcs:tilewaypoint", tile_waypoint);
        }
    }

    private static <T extends BlockEntity> BlockEntityType<T> createTile(String key, BlockEntityType.BlockEntitySupplier<T> factoryIn, Block ... blocks) {
        BlockEntityType.Builder builder = BlockEntityType.Builder.of(factoryIn, (Block[])blocks);
        return builder.build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)key));
    }

    public static Item createItem(Block block) {
        ItemNpcBlock item = new ItemNpcBlock(block, new Item.Properties());
        return item;
    }
}

