/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.crafting.OutputResolver;
import com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe;
import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class ShapedTagRecipe
extends ShapedNoMirrorRecipe {
    private final OutputResolver outputResolver;
    private ItemStack result;

    public ShapedTagRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, OutputResolver outputResolver, boolean showNotification) {
        super(group, category, pattern, ItemStack.EMPTY, showNotification);
        this.outputResolver = outputResolver;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        if (this.result == null) {
            this.result = this.outputResolver.resolve();
        }
        return this.result;
    }

    public boolean isSpecial() {
        if (this.result == null) {
            this.result = this.outputResolver.resolve();
        }
        return this.result.isEmpty();
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPED_TAG.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTagRecipe> {
        public static final MapCodec<ShapedTagRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)OutputResolver.Tag.CODEC.fieldOf("result").forGetter(recipe -> (OutputResolver.Tag)recipe.outputResolver), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification)).apply((Applicative)builder, ShapedTagRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedTagRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedTagRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedTagRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedTagRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            OutputResolver.Item result = OutputResolver.create(buffer);
            boolean showNotification = buffer.readBoolean();
            return new ShapedTagRecipe(group, category, pattern, result, showNotification);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedTagRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputResolver.resolve());
            buffer.writeBoolean(recipe.showNotification());
        }
    }
}

