/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.items.UniversalKeyChangerItem;
import net.geforcemods.securitycraft.network.server.SetPasscode;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class KeyChangerScreen
extends Screen {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private final Component ukcName = Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]);
    private final Component enterPasscode = Utils.localize("gui.securitycraft:universalKeyChanger.enterNewPasscode", new Object[0]);
    private final Component confirmPasscode = Utils.localize("gui.securitycraft:universalKeyChanger.confirmNewPasscode", new Object[0]);
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private EditBox textboxNewPasscode;
    private EditBox textboxConfirmPasscode;
    private Button confirmButton;
    private IPasscodeProtected passcodeProtected;

    public KeyChangerScreen(IPasscodeProtected passcodeProtected) {
        super((Component)Component.translatable((String)((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId()));
        this.passcodeProtected = passcodeProtected;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.confirmButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 52, this.height / 2 + 52, 100, 20, (Component)Utils.localize("gui.securitycraft:universalKeyChanger.confirm", new Object[0]), this::confirmButtonClicked, Button.DEFAULT_NARRATION));
        this.confirmButton.active = false;
        this.textboxNewPasscode = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 57, this.height / 2 - 47, 110, 12, (Component)Component.empty()));
        this.textboxNewPasscode.setMaxLength(20);
        this.setInitialFocus((GuiEventListener)this.textboxNewPasscode);
        this.textboxNewPasscode.setFilter(s -> s.matches("\\d*"));
        this.textboxNewPasscode.setResponder(s -> this.updateConfirmButtonState());
        this.textboxConfirmPasscode = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 57, this.height / 2 - 7, 110, 12, (Component)Component.empty()));
        this.textboxConfirmPasscode.setMaxLength(20);
        this.textboxConfirmPasscode.setFilter(s -> s.matches("\\d*"));
        this.textboxConfirmPasscode.setResponder(s -> this.updateConfirmButtonState());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.ukcName, this.width / 2 - this.font.width((FormattedText)this.ukcName) / 2, this.topPos + 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.enterPasscode, this.width / 2 - this.font.width((FormattedText)this.enterPasscode) / 2, this.topPos + 25, 0x404040, false);
        guiGraphics.drawString(this.font, this.confirmPasscode, this.width / 2 - this.font.width((FormattedText)this.confirmPasscode) / 2, this.topPos + 65, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void updateConfirmButtonState() {
        String newPasscode = this.textboxNewPasscode.getValue();
        String passcodeConfirmation = this.textboxConfirmPasscode.getValue();
        this.confirmButton.active = passcodeConfirmation != null && newPasscode != null && !passcodeConfirmation.isEmpty() && !newPasscode.isEmpty() && newPasscode.equals(passcodeConfirmation);
    }

    private void confirmButtonClicked(Button button) {
        IPasscodeProtected iPasscodeProtected = this.passcodeProtected;
        if (iPasscodeProtected instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iPasscodeProtected;
            PacketDistributor.sendToServer((CustomPacketPayload)new SetPasscode(be.getBlockPos(), this.textboxNewPasscode.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            iPasscodeProtected = this.passcodeProtected;
            if (iPasscodeProtected instanceof Entity) {
                Entity entity = (Entity)iPasscodeProtected;
                PacketDistributor.sendToServer((CustomPacketPayload)new SetPasscode(entity.getId(), this.textboxNewPasscode.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        Minecraft.getInstance().player.closeContainer();
        PlayerUtils.sendMessageToPlayer((Player)Minecraft.getInstance().player, Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.passcodeChanged", new Object[0]), ChatFormatting.GREEN, true);
    }
}

