/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateSliderValue
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<UpdateSliderValue> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("update_slider_value"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateSliderValue> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateSliderValue>(){

        public UpdateSliderValue decode(RegistryFriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new UpdateSliderValue(buf.readBlockPos(), buf.readUtf(), buf.readDouble());
            }
            return new UpdateSliderValue(buf.readVarInt(), buf.readUtf(), buf.readDouble());
        }

        public void encode(RegistryFriendlyByteBuf buf, UpdateSliderValue packet) {
            boolean hasPos = packet.pos != null;
            buf.writeBoolean(hasPos);
            if (hasPos) {
                buf.writeBlockPos(packet.pos);
            } else {
                buf.writeVarInt(packet.entityId);
            }
            buf.writeUtf(packet.optionName);
            buf.writeDouble(packet.value);
        }
    };
    private BlockPos pos;
    private String optionName;
    private double value;
    private int entityId;

    public UpdateSliderValue(BlockPos pos, Option<?> option, double v) {
        this(pos, option.getName(), v);
    }

    public UpdateSliderValue(BlockPos pos, String option, double v) {
        this.pos = pos;
        this.optionName = option;
        this.value = v;
    }

    public UpdateSliderValue(int entityId, Option<?> option, double v) {
        this(entityId, option.getName(), v);
    }

    public UpdateSliderValue(int entityId, String option, double v) {
        this.entityId = entityId;
        this.optionName = option;
        this.value = v;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        IOwnable ownable;
        Player player = ctx.player();
        Level level = player.level();
        ICustomizable customizable = this.getCustomizable(level);
        if (!(player.isSpectator() || customizable == null || customizable instanceof IOwnable && !(ownable = (IOwnable)((Object)customizable)).isOwnedBy((Entity)player))) {
            Option<?> option = null;
            for (Option<?> o : customizable.customOptions()) {
                if (!o.getName().equals(this.optionName)) continue;
                option = o;
                break;
            }
            if (option == null) {
                return;
            }
            if (option instanceof Option.EntityDataWrappedOption) {
                Option.EntityDataWrappedOption o = (Option.EntityDataWrappedOption)option;
                Option wrapped = o.getWrapped();
                if (wrapped instanceof Option.DoubleOption) {
                    o.setValue(this.value);
                } else if (wrapped instanceof Option.IntOption) {
                    o.setValue((int)this.value);
                }
            } else if (option instanceof Option.DoubleOption) {
                Option.DoubleOption o = (Option.DoubleOption)option;
                o.setValue(this.value);
            } else if (option instanceof Option.IntOption) {
                Option.IntOption o = (Option.IntOption)option;
                o.setValue((int)this.value);
            }
            customizable.onOptionChanged(option);
            if (customizable instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)customizable;
                level.sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    private ICustomizable getCustomizable(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof ICustomizable) {
                ICustomizable be = (ICustomizable)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof ICustomizable) {
                ICustomizable entity2 = (ICustomizable)entity;
                return entity2;
            }
        }
        return null;
    }
}

