/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SaltData
extends SavedData {
    private static final Object DUMMY = new Object();
    private static SaltData instance;
    private final Map<UUID, byte[]> saltMap = new ConcurrentHashMap<UUID, byte[]>();
    private final Map<UUID, Object> saltKeysInUse = new ConcurrentHashMap<UUID, Object>();

    private SaltData() {
    }

    public static void refreshLevel(ServerLevel level) {
        instance = (SaltData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SaltData::new, SaltData::load), "securitycraft-salts");
    }

    public static void invalidate() {
        instance = null;
    }

    public static boolean containsKey(UUID saltKey) {
        if (saltKey == null) {
            return false;
        }
        return SaltData.instance.saltMap.containsKey(saltKey);
    }

    public static void setKeyInUse(UUID saltKey) {
        if (saltKey != null) {
            SaltData.instance.saltKeysInUse.put(saltKey, DUMMY);
        }
    }

    public static boolean isKeyInUse(UUID saltKey) {
        if (saltKey == null) {
            return false;
        }
        return SaltData.instance.saltKeysInUse.containsKey(saltKey);
    }

    public static byte[] getSalt(UUID saltKey) {
        if (saltKey == null) {
            return null;
        }
        byte[] salt = SaltData.instance.saltMap.get(saltKey);
        return salt == null || salt.length == 0 ? null : salt;
    }

    public static UUID putSalt(byte[] salt) {
        UUID saltKey = UUID.randomUUID();
        SaltData.instance.saltMap.put(saltKey, salt);
        SaltData.setKeyInUse(saltKey);
        instance.setDirty();
        return saltKey;
    }

    public static void removeSalt(UUID saltKey) {
        if (saltKey != null) {
            SaltData.instance.saltMap.remove(saltKey);
            SaltData.instance.saltKeysInUse.remove(saltKey);
            instance.setDirty();
        }
    }

    public static UUID copySaltToNewKey(UUID oldKey) {
        if (oldKey != null) {
            return SaltData.putSalt(SaltData.getSalt(oldKey));
        }
        return null;
    }

    public static SaltData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        SaltData saltData = new SaltData();
        ListTag listtag = tag.getList("Salts", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag saltTag = listtag.getCompound(i);
            UUID uuid = saltTag.contains("key", 8) ? UUID.fromString(saltTag.getString("key")) : saltTag.getUUID("key");
            saltData.saltMap.put(uuid, saltTag.getByteArray("salt"));
        }
        return saltData;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag saltTable = new ListTag();
        for (Map.Entry<UUID, byte[]> saltEntry : this.saltMap.entrySet()) {
            CompoundTag saltTag = new CompoundTag();
            saltTag.putUUID("key", saltEntry.getKey());
            saltTag.putByteArray("salt", saltEntry.getValue());
            saltTable.add((Object)saltTag);
        }
        tag.put("Salts", (Tag)saltTable);
        return tag;
    }
}

